package com.bxm.localnews.thirdparty.filter.position.myTopStrategy;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author lowi
 * @date 2020/12/18 10:30
 */
@Component
public class InviteFriendsStrategy extends MyTopBannerStrategy {

    @Autowired
    private AdverProperties adverProperties;

    @Override
    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {
        if (isNotBlank(param.getCurVer()) && isGrateOrEqualThan(param.getCurVer(), "3.10.0")) {
            JSONObject extData = new JSONObject();
            if (advertVO.getExtData() != null) {
                extData = (JSONObject) advertVO.getExtData();
            }
            extData.put("isRedFlower", false);
            advertVO.setExtData(extData);
            return false;
        }
        return true;
    }

    @Override
    public String getType() {
        return adverProperties.getMyTopBannerInviteFriends();
    }
}
