package com.bxm.localnews.thirdparty.filter.position.myTopStrategy;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lowi
 * @date 2020/12/18 10:31
 */
@Component
public class MyTopRedFlowerStrategy extends MyTopBannerStrategy {

    @Autowired
    private AdverProperties adverProperties;

    @Override
    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {
        JSONObject extData = new JSONObject();
        if (advertVO.getExtData() != null) {
            extData = (JSONObject) advertVO.getExtData();
        }
        extData.put("isRedFlower", true);
        advertVO.setExtData(extData);
        return false;
    }

    @Override
    public String getType() {
        return adverProperties.getMyTopBannerRedFlower();
    }
}
