package com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.dto.LotteryDetailFacadeDTO;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.enums.FollowActEnum;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.thirdparty.vo.TopShowcaseExtDataAdver;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2020/11/20 17:38
 */
@Component
@AllArgsConstructor
@Slf4j
public class RedFlowerStrategy extends TopShowcaseStrategy {

    private final MerchantIntegrationService merchantIntegrationService;

    private final AdverProperties adverProperties;

    private final BaseUrlFacadeService baseUrlFacadeService;

    @Override
    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {
        LotteryDetailFacadeDTO lotteryInfo = merchantIntegrationService.getLotteryInfo(param.getAreaCode());
        if (lotteryInfo == null) {
            if (log.isDebugEnabled()) {
                log.debug("红花夺宝信息不存在，banner位删除此数据");
            }
            return true;
        } else {
            String jumpUrl = baseUrlFacadeService.getInnerH5BaseUrl() + adverProperties.getFlowerGainTreasureUrl();
            // 设置跳转地址
            TopShowcaseExtDataAdver flowerGainTreasureAdver = new TopShowcaseExtDataAdver();
            flowerGainTreasureAdver.setImg(lotteryInfo.getImg());
            flowerGainTreasureAdver.setJumpUrl(jumpUrl);
            String price = null;
            try {
                price = lotteryInfo.getPrice().stripTrailingZeros().toPlainString();
                flowerGainTreasureAdver.setPrice(new BigDecimal(price));
            } catch (Exception e) {
                log.error("获取红花夺宝活动商品价格转换错误: [{}],错误信息", lotteryInfo, e);
                return true;
            }
            advertVO.setExtData(flowerGainTreasureAdver);
        }
        return false;
    }

    @Override
    public Integer getType() {
        return FollowActEnum.JUMP_RED_FLOWER.getType();
    }
}
