package com.bxm.localnews.thirdparty.service;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.dto.MachineBaseResponse;
import com.bxm.localnews.thirdparty.dto.MachineResponse;
import com.bxm.localnews.thirdparty.vo.MachineState;

/**
 * 设备操作相关接口
 */
public interface MachineService {

    /**
     * 发送纸巾
     * @param machineId 机器ID
     * @return 发送结果
     */
    Json<MachineState> sendPaper(String machineId, String devcId);

    /**
     * 出纸成功的回调函数
     * @param paramData 参数主体
     * @param timestamp 请求时间戳
     * @param nonce     随机数
     * @param signature 请求签名
     * @return 接收的处理结果
     */
    MachineBaseResponse sendPaperSuccessCallback(String paramData, String timestamp, String nonce, String signature);

    /**
     * 获取设备在线状态
     * @param machineId 机器ID
     * @return 返回状态
     */
    MachineResponse getMachineOnlineStatus(String machineId);

}
