package com.bxm.localnews.thirdparty.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.config.CalendarProperties;
import com.bxm.localnews.thirdparty.dto.CalendarDTO;
import com.bxm.localnews.thirdparty.service.PerpetualCalendarService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerpetualCalendarServiceImpl implements PerpetualCalendarService {

    private HttpClientService httpClientService;

    private RedisStringAdapter redisStringAdapter;

    private CalendarProperties calendarProperties;

    @Autowired
    public PerpetualCalendarServiceImpl(HttpClientService httpClientService, RedisStringAdapter redisStringAdapter,
                                        CalendarProperties calendarProperties) {
        this.httpClientService = httpClientService;
        this.redisStringAdapter = redisStringAdapter;
        this.calendarProperties = calendarProperties;
    }

    @Override
    public CalendarDTO getTodayCalendar() {

        CalendarDTO calendarDTO = redisStringAdapter.get(getCalendarKey(), CalendarDTO.class);

        if (calendarDTO == null) {
            calendarDTO = grapCalendarInfo();
        }

        return calendarDTO;
    }

    /**
     * 获取当天的存放在redis中的key值
     *
     * @return key值
     */
    private KeyGenerator getCalendarKey() {

        KeyGenerator key = RedisConfig.THIRDPARTY_CALENDAR.copy().appendKey(getToday());

        return key;
    }

    /**
     * 获取当天的年月日
     *
     * @return
     */
    private String getToday() {
        Calendar cale = Calendar.getInstance();
        int year = cale.get(Calendar.YEAR);
        int month = cale.get(Calendar.MONTH) + 1;
        int day = cale.get(Calendar.DATE);

        return new StringBuilder().append(year).append("-").append(month).append("-").append(day).toString();
    }

    /**
     * 抓取当天的万年历数据
     *
     * @return
     */
    private CalendarDTO grapCalendarInfo() {
        CalendarDTO calendarDTO = new CalendarDTO();

        Map<String, String> map = Maps.newHashMap();
        map.put("key", calendarProperties.getKey());
        map.put("date", getToday());

        String json = this.httpClientService.doGet(calendarProperties.getUrl(), map);
        if (StringUtils.isBlank(json)) {
            return calendarDTO;
        }

        JSONObject jsonObject = JSONObject.parseObject(json);

        if (!"0".equals(jsonObject.getString("error_code"))) {
            return calendarDTO;
        }

        JSONObject jo = jsonObject.getJSONObject("result").getJSONObject("data");
        TypeReference<CalendarDTO> typeReference = new TypeReference<CalendarDTO>() {
        };
        calendarDTO = JSON.parseObject(jo.toJSONString(), typeReference);

        String day = calendarDTO.getDate().substring(calendarDTO.getDate().lastIndexOf("-") + 1,
                calendarDTO.getDate().length());
        calendarDTO.setDate(DateUtils.PATTERN_YEAR_MONTH_DAY_FORMAT.get().format(new Date()));
        calendarDTO.setDay(day);

        this.redisStringAdapter.set(getCalendarKey(), calendarDTO, 3600 * 24 * 3);

        return calendarDTO;
    }
}
