package com.bxm.localnews.thirdparty.service.impl;

import cn.binarywang.wx.miniapp.bean.WxMaTemplateData;
import cn.binarywang.wx.miniapp.bean.WxMaTemplateMessage;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.ReceiverRuleParamConstant;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.constant.WxMaTemplateEnum;
import com.bxm.localnews.thirdparty.service.PushMessageService;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.thirdparty.service.wx.push.WxMpMessageService;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class PushMessageServiceImpl implements PushMessageService {

    private final static String WE_CHAT_PUSH_URL = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send";

    private static final String JUMP_MSG_CENTER = "pages/home/home?tp=msg";

    private final WechatService wechatService;

    private final WechatProperties wechatProperties;

    private final RedisListAdapter redisListAdapter;

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final HttpClientService httpClientService;

    private final UserAuthIntegrationService userAuthIntegrationService;

    private final WxMpMessageService wxMpMessageService;

    @Autowired
    public PushMessageServiceImpl(WechatService wechatService,
                                  WechatProperties wechatProperties,
                                  RedisListAdapter redisListAdapter,
                                  RedisHashMapAdapter redisHashMapAdapter,
                                  HttpClientService httpClientService,
                                  UserAuthIntegrationService userAuthIntegrationService,
                                  WxMpMessageService wxMpMessageService
    ) {
        this.wechatService = wechatService;
        this.wechatProperties = wechatProperties;
        this.redisListAdapter = redisListAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.httpClientService = httpClientService;
        this.userAuthIntegrationService = userAuthIntegrationService;
        this.wxMpMessageService = wxMpMessageService;
    }

    @Override
    public void pushMessage(BigDecimal cash, Long userId) {
        if (null == userId || null == cash) {
            return;
        }
        UserAuth userAuth = userAuthIntegrationService.selectAppletUserAuthByUserId(userId, (byte) 7);
        if (null == userAuth) {
            return;
        }
        String userFormId = redisListAdapter.leftPop(RedisConfig.WEIXIN_FORMID.copy()
                .appendKey(wechatProperties.getAppId()).appendKey(userId), String.class);
        if (userFormId == null) {
            return;
        }

        // 推送微信消息
        JSONObject data = new JSONObject();
        JSONObject keyword1 = new JSONObject();
        JSONObject keyword2 = new JSONObject();
        keyword1.put("value", "入账" + cash.stripTrailingZeros().toPlainString() + "元");
        keyword2.put("value", "分享越多奖金越多，点击去提现");
        data.put("keyword1", keyword1);
        data.put("keyword2", keyword2);

        // 条件
        JSONObject parameters = new JSONObject();
        parameters.put("access_token", wechatService.getWeChatToken());
        parameters.put("touser", userAuth.getIdentifier());
        parameters.put("template_id", wechatProperties.getTemplateId());
        parameters.put("form_id", userFormId);
        parameters.put("data", data);
        parameters.put("emphasis_keyword", "keyword1.DATA");
        String page = wechatProperties.getPushPage();
        if (!page.endsWith("?")) {
            page += "?";
        }
        page += "inviteUserId=";
        parameters.put("page", page);
        if (log.isDebugEnabled()) {
            log.debug("weChat push params:{}", parameters);
        }
        try {
            JSONObject result = JSON.parseObject(httpClientService.doPostJson(
                    WE_CHAT_PUSH_URL + "?access_token=" + wechatService.getWeChatToken(), parameters.toJSONString()));
            log.info("weChat push result:{}", result.toJSONString());
        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.info("weChat push error", e);
            }
        }
    }

    @Override
    @Async
    public void pushTemplateMessage(PushMessage message, String appId) {
        if (StringUtils.isEmpty(appId)) {
            appId = wechatProperties.getWstAppId();
        }

        //获取模板id
        WxMaTemplateEnum templateEnum = WxMaTemplateEnum.getTemplateEnumByType(message.getPayloadInfo().getType());
        if (null == templateEnum) {
            return;
        }
        String templateId = templateEnum.getTemplateId();

        //获取用户
        Object userIds = message.getPushReceiveScope().getRuleParam().get(ReceiverRuleParamConstant.USER_IDS);
        if (null == userIds) {
            return;
        }
        log.debug("用户信息：" + JSON.toJSONString(userIds));
        //只获取第一个用户即可
        Long userId = Long.valueOf(userIds.toString());
        UserAuth userAuth = userAuthIntegrationService.selectAppletUserAuthByUserId(userId, (byte) 8);
        if (null == userAuth) {
            return;
        }
        log.debug("用户auth：" + JSON.toJSONString(userAuth));

        //构造数据
        List<WxMaTemplateData> wxMaTemplateDataList = generateTemplate(message, templateEnum);
        if (CollectionUtils.isEmpty(wxMaTemplateDataList)) {
            return;
        }

        String emphasisKeyword = getEmphasisKeyword(templateEnum);

        //发送模板消息
        sendTemplate(appId, userId, templateId, wxMaTemplateDataList, userAuth.getIdentifier(), emphasisKeyword);

    }

    /**
     * 组装模板消息
     *
     * @param message
     * @param wxMaTemplateEnum
     */
    private List<WxMaTemplateData> generateTemplate(PushMessage message, WxMaTemplateEnum wxMaTemplateEnum) {
        Map<String, Object> extend = message.getPayloadInfo().getExtend();
        log.debug("构造模板消息所需字段：" + JSON.toJSONString(extend));
        if (null == extend || CollectionUtils.isEmpty(extend.keySet())) {
            return null;
        }

        List<String> valueList = new ArrayList<>();

        String nickname = extend.get("nickname") + "";
        if (StringUtils.isBlank(nickname) || "null".equals(nickname)) {
            nickname = "神秘人";
        }

        if (PushMessageEnum.BELONG_POST_LIKE.name().equals(wxMaTemplateEnum.name())) {
            valueList.add(nickname);
            valueList.add("\uD83C\uDF39你获得" + extend.get("flowerNum") + "朵花");
            valueList.add(extend.get("postTitle") + "");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.BELONG_POST_REPLY.name().equals(wxMaTemplateEnum.name())) {
            valueList.add("\uD83D\uDD25有人评论了你的内容");
            valueList.add(nickname);
            valueList.add(extend.get("replyContent") + "");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.NEWS_LIKE.name().equals(wxMaTemplateEnum.name())
                || PushMessageEnum.POST_LIKE.name().equals(wxMaTemplateEnum.name())) {
            valueList.add("\uD83D\uDC4D有人点赞了你的评论");
            valueList.add(nickname);
            valueList.add(extend.get("replyContent") + "");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.NEWS_REPLY.name().equals(wxMaTemplateEnum.name())
                || PushMessageEnum.POST_REPLY.name().equals(wxMaTemplateEnum.name())) {
            valueList.add("✍有人回复了你的评论");
            valueList.add(nickname);
            valueList.add(extend.get("replyContent") + "");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.FORWARDING.name().equals(wxMaTemplateEnum.name())) {
            valueList.add("刚刚有人阅读了你分享的内容");
            valueList.add(nickname);
            valueList.add("\uD83C\uDF39你获得" + extend.get("flowerNum") + "朵花");
            valueList.add(DateUtils.getCurrentDateTime());
        } else if (PushMessageEnum.INVITE.name().equals(wxMaTemplateEnum.name())) {
            Object userType = extend.get("userType");
            if (null == userType) {
                return null;
            }

            if (0 == Integer.valueOf(userType.toString())) {
                valueList.add(extend.get("nickname") + "（新用户）");
                valueList.add(extend.get("nickname") + "收到了你的邀请，加入本地万事通");
            } else {
                valueList.add(extend.get("nickname") + "（老用户）");
                valueList.add(extend.get("nickname") + "收到了你的邀请，再次回到本地万事通");
            }
            valueList.add("\uD83C\uDF39你获得" + extend.get("flowerNum") + "朵花");
            valueList.add(DateUtils.getCurrentDateTime());
        }

        return generateDataList(valueList);
    }

    private List<WxMaTemplateData> generateDataList(List<String> valueList) {
        List<WxMaTemplateData> wxMaTemplateDataList = new ArrayList<>();

        for (int i = 0; i < valueList.size(); i++) {
            WxMaTemplateData keyword = new WxMaTemplateData();
            keyword.setName("keyword" + (i + 1));
            keyword.setValue(valueList.get(i));
            wxMaTemplateDataList.add(keyword);
        }

        return wxMaTemplateDataList;
    }

    /**
     * 获取放大字段
     *
     * @param wxMaTemplateEnum
     * @return
     */
    private String getEmphasisKeyword(WxMaTemplateEnum wxMaTemplateEnum) {
        if (PushMessageEnum.BELONG_POST_LIKE.name().equals(wxMaTemplateEnum.name())) {
            return "keyword2.DATA";
        } else if (PushMessageEnum.FORWARDING.name().equals(wxMaTemplateEnum.name())) {
            return "keyword3.DATA";
        } else if (PushMessageEnum.INVITE.name().equals(wxMaTemplateEnum.name())) {
            return "keyword3.DATA";
        }

        return null;
    }

    /**
     * 发送模板消息
     *
     * @param appId
     * @param userId
     * @param templateId
     * @param list
     * @param openId
     */
    private void sendTemplate(String appId, Long userId, String templateId, List<WxMaTemplateData> list, String openId, String emphasisKeyword) {
        String userFormId = redisListAdapter.leftPop(RedisConfig.WEIXIN_FORMID.copy()
                .appendKey(appId).appendKey(userId), String.class);
        if (userFormId == null) {
            return;
        }
        log.debug("form id: " + userFormId);

        try {
            log.debug("给用户[{}]发送[{}]模板消息", openId, templateId);
            wechatService.getWxMaService(appId).getMsgService().sendTemplateMsg(WxMaTemplateMessage.builder()
                    .templateId(templateId)
                    .formId(userFormId)
                    .data(list)
                    .toUser(openId)
                    .page(JUMP_MSG_CENTER)
                    .emphasisKeyword(emphasisKeyword)
                    .build());
        } catch (WxErrorException e) {
            log.warn("给用户发送模板消息失败", e);
            //重试机制
            sendTemplate(appId, userId, templateId, list, openId, emphasisKeyword);
        }
    }

    @Override
    public Message pushOfficialAccountMsg(WechatMpPushMessage wechatMpPushMessage) {
        return wxMpMessageService.singlePush(wechatMpPushMessage);
    }
}
