package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.VipInfoDetailDTO;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.UserVipIntegrationService;
import com.bxm.localnews.integration.WxOfficialAccountService;
import com.bxm.localnews.param.VipQueryParam;
import com.bxm.localnews.thirdparty.config.WechatAccountConfig;
import com.bxm.localnews.thirdparty.config.WechatMPConfig;
import com.bxm.localnews.thirdparty.constant.WechatMpTypeEnum;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WxMpAuthService;
import com.bxm.localnews.thirdparty.service.WxMpFacadeService;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.gexin.fastjson.JSON;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import me.chanjar.weixin.mp.util.WxMpConfigStorageHolder;
import org.springframework.stereotype.Service;

import java.util.Objects;

import static com.alibaba.fastjson.JSON.toJSON;
import static org.apache.commons.lang3.StringUtils.isBlank;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author zhaoyadong 2018/10/17 16:43
 * @desc
 */

@Service
@Slf4j
@AllArgsConstructor
public class WxMpAuthServiceImpl extends BaseService implements WxMpAuthService, WxMpFacadeService {

    private UserAuthIntegrationService userAuthIntegrationService;

    private UserIntegrationService userIntegrationService;

    private WxMpService wxMpService;

    private WechatAccountConfig wechatAccountConfig;

    private WechatMPConfig wechatMPConfig;

    private UserVipIntegrationService userVipIntegrationService;

    private WxOfficialAccountService wxOfficialAccountService;

    @Override
    public Message getUserByCode(String code, String type) {
        swtichWechatMp(type);
        String appId = WxMpConfigStorageHolder.get();
        WxUserInfo wxUserInfo = getWxUserInfoByCode(code, type);
        if (Objects.nonNull(wxUserInfo) && StringUtils.isNotBlank(appId)) {
            wxOfficialAccountService.focusOnOfficialAccount(wxUserInfo.getOpenId(), wxUserInfo.getUnionId(), appId, Objects.isNull(wxUserInfo.getUnionId()) ? 0 : 1);
        }

        if (null == wxUserInfo) {
            return Message.build(false);
        }
        Message wxUserInfoMessage = Message.build(true).addParam("wxUserInfo", wxUserInfo);
        if (wxUserInfoMessage.isSuccess()) {
            UserAuth userAuth = userAuthIntegrationService.selectUserAuthByUnionId(wxUserInfo.getUnionId());
            if (null != userAuth) {
                wxUserInfo.setUserId(userAuth.getUserId());
                wxUserInfo.setStatus(2);

                UserInfoDTO userCache = userIntegrationService.getUserFromRedisDB(userAuth.getId());
                if (null != userCache && userCache.getState() != null
                        && userCache.getState() == AppConst.USER_STATE.NORMAL) {
                    wxUserInfo.setRegUser(true);
                }

                VipQueryParam vipQueryParam = new VipQueryParam();
                vipQueryParam.setUserId(userAuth.getUserId());

                VipInfoDetailDTO vipDetail = userVipIntegrationService.getVipDetail(vipQueryParam);

                if (vipDetail != null) {
                    wxUserInfo.setStatus(vipDetail.getStatus());
                }

            }
            if (log.isDebugEnabled()) {
                logger.debug("根据code获取用户信息:[{}]", toJSON(wxUserInfo));
            }
        }

        return wxUserInfoMessage;
    }

    @Override
    public WxMpUserList getUserList(String nextOpenId) {
        try {
            return wxMpService.getUserService().userList(nextOpenId);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public WxMpUser getUser(String openId) {
        try {
            return wxMpService.getUserService().userInfo(openId);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public WxUserInfo getWxUserInfoByCode(String authCode, String type) {
        if (isBlank(authCode)) {
            return null;
        }

        WxUserInfo wxUserInfo = null;
        try {
            swtichWechatMp(type);

            WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(authCode);
            WxMpUser wxMpUser = wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
            wxUserInfo = convertWxMpUser(wxMpUser);
        } catch (WxErrorException e) {
            logger.error(e.getMessage(), e);
        }
        return wxUserInfo;
    }

    /**
     * 获取的微信用户信息转换为自己所需要的用户信息
     *
     * @param wxMpUser
     * @return
     */
    private WxUserInfo convertWxMpUser(WxMpUser wxMpUser) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        wxUserInfo.setOpenId(wxMpUser.getOpenId());
        //unionId主要是为了让app和公众号共用一个账号
        wxUserInfo.setUnionId(wxMpUser.getUnionId());
        wxUserInfo.setHeadImg(wxMpUser.getHeadImgUrl());
        if (StringUtils.isEmpty(wxMpUser.getHeadImgUrl())) {
            wxUserInfo.setHeadImg(userIntegrationService.getDefaultHeadImgUrl());
        }
        wxUserInfo.setNickname(wxMpUser.getNickname());

        return wxUserInfo;
    }

    /**
     * 切换使用的微信公众号
     *
     * @param type
     */
    private void swtichWechatMp(String type) {
        // 如果携带了type的值
        while (isNotBlank(type)) {

            // 先判断是否是js api
            if (WechatMpTypeEnum.JS_API.name().equals(type)) {
                WxMpConfigStorageHolder.set(wechatAccountConfig.getJsapiAppId());
                break;
            }

            // 再根据type查询是否有配置的appid
            String appId = wechatMPConfig.getAppIdByType().get(type);
            if (isNotBlank(appId)) {
                WxMpConfigStorageHolder.set(appId);
                break;
            }

            // 否则就是未定义type的，统统使用h5的配置进行返回
            WxMpConfigStorageHolder.set(wechatAccountConfig.getH5AppId());
            break;
        }

        if (log.isDebugEnabled()) {
            log.debug("切换公众号，根据类型: {}最终使用的公众号信息为: {}", type, WxMpConfigStorageHolder.get());
        }
    }

    @Override
    public WxJsapiSignature getWxJsapiSignature(String url, String type) {
        try {
            swtichWechatMp(type);
            if (log.isDebugEnabled()) {
                log.debug("启用的配置信息: {}", JSON.toJSONString(wxMpService.getWxMpConfigStorage()));
                // 启用完之后 代理方法默认会回退到原有配置，所以这里需要再set一次
                swtichWechatMp(type);
            }

            return wxMpService.createJsapiSignature(url);
        } catch (WxErrorException e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String getWechatOnAuth2Url(String redirectURI, String scope, String state, String type) {
        swtichWechatMp(type);

        return String.format(WxMpService.CONNECT_OAUTH2_AUTHORIZE_URL,
                wxMpService.getWxMpConfigStorage().getAppId(), redirectURI,
                scope, org.apache.commons.lang3.StringUtils.trimToEmpty(state));

    }

    @Override
    public String getAccessToken() {
        String accessToken = null;
        try {
            // 使用H5活动公众号信息
            WxMpConfigStorageHolder.set(wechatAccountConfig.getH5AppId());
            accessToken = wxMpService.getAccessToken();
        } catch (WxErrorException e) {
            logger.error("获取accessToken 失败:");
            logger.error(e.getMessage(), e);
        }
        return accessToken;
    }

    @Override
    public Boolean subscribeWechat(String openId) {
        try {
            WxMpUser wxMpUser = wxMpService.getUserService().userInfo(openId);
            return wxMpUser.getSubscribe();
        } catch (WxErrorException e) {
            logger.error(e.getMessage(), e);
            return false;
        }
    }
}
