package com.bxm.localnews.thirdparty.service.jump.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.ThirdpartyJumpInfoProperties;
import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.JumpInfoConvert;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

import java.nio.charset.Charset;
import java.util.Optional;

import static com.alibaba.fastjson.JSON.toJSONString;
import static java.lang.String.format;
import static java.util.Objects.isNull;
import static org.apache.commons.lang3.StringUtils.join;

/**
 * 团油跳转
 * @author Gonzo
 * @date  2020-07-15 10:03
 * @since 3.4.0
 */
@Slf4j
@Component
public class OilJumpInfoConvert extends AbstractJumpInfoConvert {

    @Autowired
    private ThirdpartyJumpInfoProperties thirdpartyJumpInfoProperties;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Override
    public Optional<JumpInfo> doConvert(JumpInfoConvertParam param) {
        UserInfoDTO userFromRedisDB = userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (isNull(userFromRedisDB)) {
            return Optional.empty();
        }
        JumpInfo jumpInfo = new JumpInfo();
        // 替换占位符
        String uri = format(thirdpartyJumpInfoProperties.getOilUrl(), userFromRedisDB.getPhone());
        // 源跳转地址
        jumpInfo.setSourceJumpUrl(uri);
        // url编码，添加webview协议
        jumpInfo.setProtocol(join(WEB_VIEW_PROTOCAL, UriUtils.encode(uri, Charset.defaultCharset())));

        if (log.isDebugEnabled()) {
            log.debug("获取团油的跳转信息为: {}", toJSONString(jumpInfo));
        }
        // 返回
        return Optional.of(jumpInfo);
    }

    @Override
    public OrderJumpType support() {
        return OrderJumpType.OIL_ORDER;
    }
}
