package com.bxm.localnews.thirdparty.service.jump.impl;


import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.JumpInfoConvert;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Optional;

@Slf4j
@Component
public class TaoKeOrderJumpInfoConvert extends AbstractJumpInfoConvert {

    private static final String ORDER_PROTOCAL = "wst://mine/billingDetail";

    @Override
    public Optional<JumpInfo> doConvert(JumpInfoConvertParam param) {
        return Optional.of(new JumpInfo("", ORDER_PROTOCAL));
    }

    @Override
    public OrderJumpType support() {
        return OrderJumpType.TAOKE_ORDER;
    }

}
