package com.bxm.localnews.thirdparty.service.pop;

import java.util.Arrays;
import java.util.Optional;

/**
 * 弹窗类型
 *
 * @author Gonzo
 * @date 2020-08-22 11:34
 */
public enum PopTypeEnum {

    /**
     * 版本弹窗
     */
    VERSION_POP(10000, "版本弹窗"),
    ACTIVITY_POP(10010, "活动弹窗"),
    VOTE_POP(10005, "投票弹窗"),
    HOME_PAGE_POP(10010, "个人主页弹窗"),
    RED_PACKAGE_POP(10001, "红包弹窗"),
    WITHDRAW_POP(10002, "引导提现弹窗"),
    PERFECT_INFORMATION_POP(10006, "完善资料弹窗"),
    ADVERT_POP(10003, "广告弹窗"),
    VIP_POP(10004, "VIP弹窗"),
    NOTE_NUM_POP(10007, "小纸条发布数弹窗"),
    HOME_TOPIC_POP(10011, "首页注册来源为话题的话题弹窗"),
    THRUST_ADVERT_POP(10012, "插屏广告弹窗"),
    VIP_ACTIVATION_SUCCESS(10013, "站外会员卡激活成功弹窗"),
    ACTIVATION_HAS_NOT_CHANCE(10014, "站外激活会员卡但是没有次数了，站内弹窗"),
    BIND_POP(10015, "员工绑定成功弹窗"),
    PRIVACY_POP(10016, "隐私弹窗"),
    HOME_CHANNEL_POP(10017, "主页栏目引导弹窗"),
    LOCAL_CYCLE_POP(10018, "本地圈引导弹窗"),
    PLUS_POP(10019, "+号发帖按钮引导弹窗"),
    MINE_INVITE_POP(10020, "我的页面邀请好友的引导弹窗"),
    NORMAL_GUIDE_POP(10021, "普通新用户的引导弹窗"),
    VIP_GUIDE_POP(10022, "vip新用户的引导弹窗"),
    VIP_POSITION_POP(10023, "vip页面的引导弹窗"),
    NEW_GUIDE_POP(10024, "3.9.0版本引导弹窗"),
    VIP_PAGE_TAB_POP(10025, "3.11.0 vip页面tab引导弹窗");

    private int type;

    private String desc;

    PopTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据类型获取枚举
     *
     * @param type 类型
     * @return PopTypeEnum 枚举
     */
    public static Optional<PopTypeEnum> getByType(int type) {
        return Arrays.stream(PopTypeEnum.values()).filter(p -> p.type == type).findFirst();
    }
}
