package com.bxm.localnews.thirdparty.service.pop.popinstance;

import com.bxm.localnews.thirdparty.service.pop.popstrategy.PopStrategy;

import java.util.Map;

public interface Pop {

    /**
     * 下一个弹窗
     *
     * @return 弹窗
     */
    Pop next();

    /**
     * 设置下一个弹窗
     *
     * @param
     */
    void setNext(Pop pop);

    /**
     * 执行逻辑
     *
     * @param context 弹窗上下文
     */
    void process(PopContext context);

    /**
     * 前置执行逻辑
     *
     * @param context
     * @return
     */
    boolean beforeFilter(PopContext context);

    /**
     * 后置执行逻辑
     *
     * @param context
     */
    void afterFilter(PopContext context);

    /**
     * 设置弹窗策略
     *
     * @param popStrategy
     */
    void setPopStrategy(PopStrategy popStrategy);

    /**
     * 设置参数
     *
     * @param param
     */
    void setParam(Map<String, Object> param);

}
