package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.thirdparty.service.pop.popinstance.Pop;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.PopStrategy;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

@Slf4j
public abstract class AbstractPop implements Pop {

    private Pop nextPop;

    private PopStrategy popStrategy;

    private Map<String, Object> param;

    @Override
    public Pop next() {
        if (null == nextPop) {
            return new DefaultPop();
        }
        return nextPop;
    }

    @Override
    public void setNext(Pop pop) {
        nextPop = pop;
    }

    @Override
    public void process(PopContext context) {
        init(context);

        // 如果在弹窗策略里判断为正确，则调用具体弹窗逻辑
        if (beforeFilter(context)) {
            //弹窗具体若没有值返回true，继续取下一个优先级
            if (filter(context)) {
                log.debug("{}【首页弹窗】成功弹出弹窗:[{}]",this.getClass().getName(), JSONObject.toJSON(context));
                afterFilter(context);
            } else {
                next().process(context);
            }
        } else {
            next().process(context);
        }
    }

    /**
     * 设置运行时初始化参数
     * @param context context
     */
    protected void init(PopContext context) {
        if (null != param) {
            context.getParamMap().putAll(param);
        }
    }

    /**
     * 从弹窗策略中进行判断
     *
     * @param context
     * @return
     */
    @Override
    public boolean beforeFilter(PopContext context) {
        return popStrategy.judge(context);
    }

    /**
     * 弹窗弹出之后执行缓存保留
     *
     * @param context
     */
    @Override
    public void afterFilter(PopContext context) {
        popStrategy.cache(context);
    }

    @Override
    public void setPopStrategy(PopStrategy popStrategy) {
        this.popStrategy = popStrategy;
    }

    @Override
    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    /**
     * 弹窗过滤，执行弹窗的逻辑
     *
     * @param context
     * @return
     */
    abstract boolean filter(PopContext context);

}
