package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.gexin.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 广告弹窗
 */
@Slf4j
@Service
public class AdvertPop extends AbstractPop {

    @Autowired
    private AdvertService advertService;

    @Override
    public boolean filter(PopContext context) {
        log.debug("开始处理广告弹窗，开始时间：" + System.currentTimeMillis());
        boolean result = false;

        HomeWindowParam homeWindowParam = context.getHomeWindowParam();
        List<AdvertVO> advertDtoList = advertService.queryAdByType(
                (byte) 1, homeWindowParam.getAreaCode(), homeWindowParam.getUserId(), homeWindowParam);
        if (CollectionUtils.isNotEmpty(advertDtoList)) {
            if (log.isDebugEnabled()) {
                log.debug("获取到了弹窗广告们进行封装: {}", JSON.toJSONString(advertDtoList));
            }
            HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
            homeWindowDTO.setAdvertDTOList(advertDtoList);
            homeWindowDTO.setType(PopTypeEnum.ADVERT_POP.getType());
            context.setHomeWindowDTO(homeWindowDTO);
            result = true;
        }

        log.debug("结束处理广告弹窗，结束时间：" + System.currentTimeMillis());
        return result;
    }

}
