package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.URLEncoder;

import static com.google.common.base.Charsets.UTF_8;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * 个人主页弹窗
 */
@Slf4j
@Service
public class HomePagePop extends AbstractPop {

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private BizConfigProperties bizConfigProperties;

    @Autowired
    private BaseUrlFacadeService baseUrlFacadeService;

    @Override
    public boolean filter(PopContext context) {
        log.debug("开始处理个人主页弹窗，开始时间：" + System.currentTimeMillis());
        boolean result = false;

        HomeWindowParam homeWindowParam = context.getHomeWindowParam();
        String homePageUrl = getHomePage(homeWindowParam.getUserId());
        if (isNotBlank(homePageUrl)) {
            context.setHomeWindowDTO(new HomeWindowDTO(PopTypeEnum.HOME_PAGE_POP.getType(), homePageUrl));
            result = true;
        }

        log.debug("结束处理个人主页弹窗，结束时间：" + System.currentTimeMillis());
        return result;
    }

    private String getHomePage(Long userId) {
        UserInfoDTO userInfo = userIntegrationService.getUserFromRedisDB(userId);

        if (null != userInfo) {
            //判断用户是否为个人主页注册
            if (InviteTypeEnum.PERSONAL_HOMEPAGE.getName().equalsIgnoreCase(userInfo.getRegisterChannel())
                    && null != userInfo.getInviteUserId()
                    && null != userInfo.getRelationId()) {

                UserInfoDTO inviteUserInfo = userIntegrationService.getUserFromRedisDB(userInfo.getRelationId());

                String nickname = null == inviteUserInfo.getNickname() ? "匿名" : inviteUserInfo.getNickname();
                String headImg = null == inviteUserInfo.getHeadImg() ? userIntegrationService.getDefaultHeadImgUrl() : inviteUserInfo.getHeadImg();

                try {
                    StringBuilder sb = new StringBuilder(baseUrlFacadeService.getInnerH5BaseUrl());
                    sb.append("/index.html#/guideFollow?userId=");
                    sb.append(userId);
                    sb.append("&userName=");
                    sb.append(URLEncoder.encode(nickname, UTF_8.name()));
                    sb.append("&userUrl=");
                    sb.append(URLEncoder.encode(headImg, UTF_8.name()));
                    sb.append("&followUserId=");
                    sb.append(inviteUserInfo.getId());

                    return sb.toString();
                } catch(Exception e) {
                    log.error("生成收个人注册弹窗地址失败", e);
                }
            }
        }

        return null;
    }

}
