package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.PopupProperties;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.dto.NewVersionNoviceUserGuideDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import static java.util.Objects.isNull;

/**
 * 非vip用户的引导弹窗
 *
 * @author gonzo
 * @date 2020-08-21 13:54
 **/
@Slf4j
@Component
@AllArgsConstructor
public class NewVersionGuidePop extends AbstractGuidePopup {

    private final UserIntegrationService userIntegrationService;

    private final PopupProperties popupProperties;

    @Override
    boolean filter(PopContext context) {
        // 调用公共的校验
        if (!super.filter(context)) {
            return false;
        }

        HomeWindowParam param = context.getHomeWindowParam();
        LocationDetailDTO locationDetailDTO = context.getParam(LOCATION_DETAIL_DTO);

        // 查询用户信息
        UserInfoDTO userInfo = userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (isNull(userInfo)) {
            log.warn("用户: {}不存在，跳过3.9.0版本用户的引导弹窗", param.getUserId());
            return false;
        }

        // 判断用户是新版本注册用户
        if (!check390JudgeMarker(userInfo.getJudgeMarker())) {
            log.info("用户: {} 非新版本用户 增加弹出缓存，永不弹出", param.getUserId());
            super.closeCache(context);
            return false;
        }

        // 新版本引导弹窗数据填充
        open(context, locationDetailDTO, userInfo, param);

        // 弹出
        return true;
    }


    /**
     * 设置弹窗数据
     * @param context
     * @param locationDetailDTO
     * @param userInfo
     * @param param
     */
    private void open(PopContext context, LocationDetailDTO locationDetailDTO, UserInfoDTO userInfo, HomeWindowParam param) {
        NewVersionNoviceUserGuideDTO normalNoviceUserGuide = new NewVersionNoviceUserGuideDTO();
        normalNoviceUserGuide.setUserId(param.getUserId());
        normalNoviceUserGuide.setImgUrl(userInfo.getHeadImg());
        normalNoviceUserGuide.setNickName(userInfo.getNickname());
        normalNoviceUserGuide.setAreaName(locationDetailDTO.getName());
        normalNoviceUserGuide.setServerHeadImg(popupProperties.getServerHeadImg());
        HomeWindowDTO windowDTO = new HomeWindowDTO();
        windowDTO.setType(PopTypeEnum.NEW_GUIDE_POP.getType());
        windowDTO.setNewVersionNoviceUserGuide(normalNoviceUserGuide);

        context.setHomeWindowDTO(windowDTO);
    }

    @Override
    protected boolean autoCache() {
        // 弹窗一次就添加关闭的缓存
        return true;
    }

    @Override
    protected String afterIncludeVersion() {
        // 3.9.0以后才弹出
        return VER_3_9_0;
    }

    @Override
    protected String beforeExcludeVersion() {
        return "";
    }

}
