package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.dto.UserRedPacketDTO;
import com.bxm.localnews.integration.UserRedPacketIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 新人红包弹窗
 */
@Slf4j
@Service
public class RedPackagePop extends AbstractPop {

    @Autowired
    private UserRedPacketIntegrationService userRedPacketIntegrationService;

    @Override
    public boolean filter(PopContext context) {
        log.debug("开始处理红包弹窗，开始时间：" + System.currentTimeMillis());
        boolean result = false;

        HomeWindowParam homeWindowParam = context.getHomeWindowParam();
        UserRedPacketDTO userRedPacketDTO = userRedPacketIntegrationService.enableRedPacket(homeWindowParam.getDevcId(), homeWindowParam.getUserId(), homeWindowParam.getAreaCode());
        if (userRedPacketDTO != null && userRedPacketDTO.getEnableRedPacket() != null && userRedPacketDTO.getEnableRedPacket()) {
            HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
            homeWindowDTO.setUserRedPacketDTO(userRedPacketDTO);
            homeWindowDTO.setType(PopTypeEnum.RED_PACKAGE_POP.getType());
            context.setHomeWindowDTO(homeWindowDTO);
            result = true;
        }

        log.debug("结束处理红包弹窗，结束时间：" + System.currentTimeMillis());
        return result;
    }

}
