package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.thirdparty.config.PopupProperties;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 插屏广告弹窗
 */
@Slf4j
@Service
public class ThrustAdvertPop extends AbstractPop {

    @Autowired
    private AppVersionSupplyService appVersionSupplyService;

    @Autowired
    private PopupProperties popupProperties;

    private static final String SUPPORT_VERSION = "3.1.4";

    @Override
    public boolean filter(PopContext context) {
        log.debug("开始处理插屏广告弹窗，开始时间：" + System.currentTimeMillis());

        if (Objects.equals(popupProperties.getThrustAdvertPopSwitch(), Boolean.TRUE)) {
            if (appVersionSupplyService.isHighVersion(context.getHomeWindowParam().getCurVer(), SUPPORT_VERSION) >= 0) {
                HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
                homeWindowDTO.setType(PopTypeEnum.THRUST_ADVERT_POP.getType());
                context.setHomeWindowDTO(homeWindowDTO);
                return true;
            }
        }

        log.debug("结束插屏广告弹窗，结束时间：" + System.currentTimeMillis());
        return false;
    }

}
