package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.ForumPostIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.vo.TopicFacadeVO;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

import static com.bxm.localnews.common.constant.RedisConfig.CONTENT_GUIDE_KEY;

/**
 * 首页注册来源为话题的话题弹窗
 * @author Gonzo
 * @date 2019-12-23 10:09
 */
@Service
@Slf4j
public class TopicPop extends AbstractPop {

    @Autowired
    private ForumPostIntegrationService forumPostIntegrationService;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    protected boolean filter(PopContext context) {
        Long userId = context.getHomeWindowParam().getUserId();

        if (Objects.nonNull(userId)) {

            // 判断用户是否有过投票引导弹窗（这个key以往是投票引导的，后来慢慢的站外邀请如果通过小纸条啊，新闻什么的都是用这个key）
            // 所以为了兼容业务，这里继续用这个key，可能有点歧义
            if (!redisSetAdapter.exists(CONTENT_GUIDE_KEY, userId)) {
                UserInfoDTO userInfoDTO = userIntegrationService.getUserFromRedisDB(userId);

                // 用户不为空 且邀请途径为话题
                if (Objects.nonNull(userInfoDTO) && Objects.nonNull(userInfoDTO.getId())
                        && Objects.equals(InviteTypeEnum.TOPIC.getName(), userInfoDTO.getRegisterChannel())) {

                    TopicFacadeVO topicFacadeVO = forumPostIntegrationService.getTopicById(userInfoDTO.getRelationId());

                    if (Objects.nonNull(topicFacadeVO)) {
                        HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
                        homeWindowDTO.setTopicFacadeVO(topicFacadeVO);
                        homeWindowDTO.setType(PopTypeEnum.HOME_TOPIC_POP.getType());
                        context.setHomeWindowDTO(homeWindowDTO);
                        return true;
                    }
                }
            }

        }
        return false;
    }
}
