/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.activity.common.config.AdvertProperties;
import com.bxm.localnews.common.rediskey.UserRedisKey;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.service.AdvertService;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author:jieli.xu 会员激活成功弹窗
 */
@Service
@Slf4j
public class VipActivePop extends AbstractPop {

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private AdvertService advertService;

    @Autowired
    private AdvertProperties advertProperties;

    @Override
    boolean filter(PopContext context) {
        boolean flag = false;
        HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
        homeWindowDTO.setType(PopTypeEnum.VIP_ACTIVATION_SUCCESS.getType());
        String info = redisHashMapAdapter.get(UserRedisKey.HASH_USER_ACTIVE_VIP_FIRST,
                String.valueOf(context.getHomeWindowParam().getUserId()), String.class);
        // 如果缓存里面有值 且当前弹窗的缓存没有 则表示没有弹过
        if (isNotBlank(info)
                //  0表示不需要弹出
                && !Objects.equals("0", info)) {
            flag = true;
            homeWindowDTO.setVipActivationPop(true);
            //加载素材信息
            AdvertVO advertVO = advertService.getByMateriaId(advertProperties.getVipActivationMateriaId());
            List<AdvertVO> advertDTOList = new ArrayList<>(1);
            advertDTOList.add(advertVO);
            homeWindowDTO.setAdvertDTOList(advertDTOList);
        }
        context.setHomeWindowDTO(homeWindowDTO);
        return flag;
    }
}
