package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

import static com.bxm.newidea.component.tools.BitOperatorUtil.getBitAsBoolean;
import static java.util.Objects.isNull;

/**
 * 3.11.0 vip页引导弹窗（本身不是新人引导弹窗）
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/14 9:35 上午
 */
@Slf4j
@Component
@AllArgsConstructor
public class VipPageTabPop extends AbstractPop {

    private final UserIntegrationService userIntegrationService;

    @Override
    boolean filter(PopContext context) {

        HomeWindowParam param = context.getHomeWindowParam();

        //未传递版本直接跳过
        if (Objects.isNull(param.getCurVer())) {
            return false;
        }
        //首先判断是否大于3.11.0，如果不是跳过
        if (Boolean.FALSE.equals(StringUtils.isGrateOrEqualThan(param.getCurVer(), "3.11.0"))) {
            return false;
        }

        // 查询用户信息
        UserInfoDTO userInfo = userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (isNull(userInfo)) {
            log.warn("用户: {}不存在，跳过3.11.0版本VIP Tab弹窗", param.getUserId());
            return false;
        }

        //判断是否是3.11.0注册用户，如果是则跳过否则弹出
        if (check3110JudgeMarker(userInfo.getJudgeMarker())) {
            log.info("用户: {} 是新版本3.11.0用户，不弹出vip tab", param.getUserId());
            return false;
        }

        HomeWindowDTO homeWindowDTO = new HomeWindowDTO();

        homeWindowDTO.setType(PopTypeEnum.VIP_PAGE_TAB_POP.getType());
        context.setHomeWindowDTO(homeWindowDTO);
        return true;
    }

    /**
     * 是否3.11.0以后注册的用户
     *
     * @param judgeMarket
     * @return true 是3.11.0以后新用户
     */
    protected boolean check3110JudgeMarker(Long judgeMarket) {
        // 判断用户是新版本注册用户
        return getBitAsBoolean(judgeMarket, LocalNewsUserJudgeMarkerEnum.VER_3_11_0.getIndex());
    }
}