package com.bxm.localnews.thirdparty.service.pop.popstrategy.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.PopStrategy;
import com.bxm.newidea.component.redis.KeyGenerator;

/**
 * 弹窗策略抽象类
 */
public abstract class AbstractPopStrategy implements PopStrategy {
    /**
     * 弹窗key
     */
    public static final String KEY = "key";
    /**
     * 总共弹出次数
     */
    public static final String NUM = "num";
    /**
     * 相隔多少天弹出key
     */
    public static final String DAY_NUM = "dayNum";

    /**
     * 获取弹窗策略redis缓存key
     *
     * @param userId
     * @return
     */
    public static KeyGenerator getRedisKey(Long userId) {
        return RedisConfig.USER_CACHE_POPUP.copy().appendKey(userId);
    }

}
