package com.bxm.localnews.thirdparty.service.pop.popstrategy.impl;

import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 次数弹窗策略
 */
@Service
public class PopOnceStrategy extends AbstractPopStrategy {

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public boolean judge(PopContext popContext) {
        //获取弹窗的key
        String subKey = popContext.getParam(KEY);

        //获取弹窗的指定弹出次数
        Integer settingNum = popContext.getParam(NUM);
        if (null == settingNum) {
            settingNum = 1;
        }

        //用户弹窗缓存map
        PopCache cache = popContext.getCacheMap().get(subKey);

        if (null != cache) {
            // 获取是否可以弹窗的标识
            boolean isPop = cache.isPopUp();

            //当前弹窗的缓存num
            Integer num = cache.getParam(NUM);

            if (isPop) {
                if (num != null) {
                    //得到已经弹窗的数量
                    if (num < settingNum) {
                        int updateNum = num + 1;
                        if (updateNum >= settingNum) {
                            cache.setPopUp(false);
                        }
                        cache.addParam(NUM, updateNum);
                        return true;
                    }
                } else {
                    cache.addParam(NUM, 1);
                    return true;
                }
            }
        } else {
            cache = new PopCache();
            cache.addParam(NUM, 1);
            if (1 >= settingNum) {
                cache.setPopUp(false);
            }
            popContext.getCacheMap().put(subKey, cache);
            return true;
        }
        return false;
    }

    @Override
    public void cache(PopContext popContext) {
        //获取弹窗的key
        String subKey = popContext.getParamMap().get(KEY).toString();
        //保存弹窗缓存信息
        redisHashMapAdapter.put(getRedisKey(popContext.getHomeWindowParam().getUserId()),
                subKey, popContext.getCacheMap().get(subKey));
    }
}
