package com.bxm.localnews.thirdparty.service.strategy;

import com.bxm.localnews.thirdparty.constant.WxMaTypeEnum;
import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxMaUserData;

import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;

/**
 * @author zhaoyadong 2019/5/24 9:51
 * @desc
 */
public interface WxMinaAppStrategyService {
    /**
     * 小程序对应的类型枚举
     *
     * @return 返回当前支持的小程序类型
     */
    WxMaTypeEnum support();

    /**
     * 小程序授权登陆：解密用户信息
     *
     * @param wxMaUserData
     * @return
     */
    WxMaUserInfo getUserInfo(WxMaUserData wxMaUserData);

    /**
     * 小程序静默登陆：根据code码获取openId、sessionKey相关信息
     *
     * @param wechatDto
     * @return
     */
    WxMaJscode2SessionResult getOpenIdByCode(WechatDto wechatDto);
}
