package com.bxm.localnews.thirdparty.service.wx.push.templateStrategy;

import com.bxm.localnews.mq.common.enums.WxMpTemplateEnum;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

/**
 * @author lowi
 * @date 2020/11/20 17:23
 */
@Component
public class WxTemplateContextProcess {

    private HashMap<WxMpTemplateEnum, TemplateStrategy> strategyMap;

    public WxTemplateContextProcess(List<TemplateStrategy> strategies) {
        strategyMap = new HashMap<>((int) (strategies.size() / .75f) + 1);
        strategies.forEach(entity -> strategyMap.put(entity.getType(), entity));
    }


    public String getTemplateId(WxMpTemplateEnum template) {
        TemplateStrategy templateStrategy = strategyMap.get(template);
        if (templateStrategy == null) {
            return null;
        }
        return templateStrategy.getTemplateId(template);
    }
}
