/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.advert.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.advert.AdvertCallbackService;
import com.bxm.localnews.thirdparty.config.ThirdPartyProperties;
import com.bxm.localnews.thirdparty.param.AdvertCallbackCommonParam;
import com.bxm.localnews.thirdparty.param.AiqiyiAdvertCallbackParam;
import com.bxm.localnews.thirdparty.param.BaiduAdvertCallbackParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertCallbackServiceImpl
implements AdvertCallbackService {
    private static final Logger log = LoggerFactory.getLogger(AdvertCallbackServiceImpl.class);
    private final OKHttpService okHttpService;
    private final RedisStringAdapter redisStringAdapter;
    private final ThirdPartyProperties thirdPartyProperties;
    private static final long EXPIRE_TIME = 18000L;

    @Autowired
    public AdvertCallbackServiceImpl(OKHttpService okHttpService, RedisStringAdapter redisStringAdapter, ThirdPartyProperties thirdPartyProperties) {
        this.okHttpService = okHttpService;
        this.redisStringAdapter = redisStringAdapter;
        this.thirdPartyProperties = thirdPartyProperties;
    }

    @Override
    public void baiduCallback(BaiduAdvertCallbackParam param) {
        log.debug("\u767e\u5ea6\u5e7f\u544a\u8bf7\u6c42\u70b9\u51fb\uff1a{}", (Object)param);
        String androidId = param.getAndroid_id();
        this.redisStringAdapter.set(RedisConfig.AD_CALLBACK.copy().appendKey((Object)androidId), (Object)this.convert(param), 18000L);
    }

    private AdvertCallbackCommonParam convert(BaiduAdvertCallbackParam param) {
        return AdvertCallbackCommonParam.builder().callback(param.getCallback_url()).imei(param.getImei_md5()).timestamp(param.getTs()).type(AdType.BAIDU.name()).build();
    }

    @Override
    public void aiqiyiCallback(AiqiyiAdvertCallbackParam param) {
        log.debug("\u7231\u5947\u827a\u5e7f\u544a\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)param);
        String androidId = param.getAndroidid();
        this.redisStringAdapter.set(RedisConfig.AD_CALLBACK.copy().appendKey((Object)androidId), (Object)this.convert(param), 18000L);
    }

    private AdvertCallbackCommonParam convert(AiqiyiAdvertCallbackParam param) {
        return AdvertCallbackCommonParam.builder().callback(param.getCallback_url()).imei(param.getImei()).timestamp(Long.valueOf(NumberUtils.parseToLong((String)param.getTimestamp()))).type(AdType.AIQIYI.name()).build();
    }

    @Override
    public boolean triggerCallback(String androidId) {
        String callbackUrl;
        KeyGenerator key = RedisConfig.AD_CALLBACK.copy().appendKey((Object)androidId);
        AdvertCallbackCommonParam param = (AdvertCallbackCommonParam)this.redisStringAdapter.get(key, AdvertCallbackCommonParam.class);
        if (param == null) {
            String md5AndrondId = MD5Util.md5((String)androidId).toLowerCase();
            key = RedisConfig.AD_CALLBACK.copy().appendKey((Object)md5AndrondId);
            param = (AdvertCallbackCommonParam)this.redisStringAdapter.get(key, AdvertCallbackCommonParam.class);
            log.debug("\u5c1d\u8bd5\u4f7f\u7528MD5\u83b7\u53d6\uff1a{},param:{}", (Object)md5AndrondId, (Object)param);
            if (param == null) {
                log.debug("\u8bf7\u6c42\u7684\u5b89\u5353ID\u4e0d\u5b58\u5728\uff1a{}", (Object)androidId);
                return false;
            }
        }
        if (param.getTimestamp() > 0L) {
            Date regDate = new Date();
            Date requestDate = new Date(param.getTimestamp());
            if (log.isDebugEnabled()) {
                log.debug("request timestamp:{},date:{}", (Object)param.getTimestamp(), (Object)DateUtils.formatDateTime((Date)requestDate));
            }
            if (DateUtils.after((Date)requestDate, (Date)regDate)) {
                log.error("{} \u8bbe\u5907\u6ce8\u518c\u65f6\uff0c\u5e7f\u544a\u56de\u8c03\u4fe1\u606f\u5df2\u8fc7\u671f\u3002\u5e7f\u544a\u8bf7\u6c42\u65f6\u95f4\uff1a{}", (Object)androidId, (Object)requestDate);
                this.redisStringAdapter.remove(key);
                return false;
            }
        }
        if (AdType.BAIDU.name().equals(param.getType())) {
            callbackUrl = this.buildBaiduCallbackUrl(param.getCallback());
            String response = this.okHttpService.get(callbackUrl, (Map)Maps.newHashMap());
            log.debug("response:{}", (Object)response);
            JSONObject json = JSON.parseObject((String)response);
            if (json.getIntValue("error_code") != 0) {
                log.error("baidu advert callback error,response:{},request:{}", (Object)response, (Object)param);
                return false;
            }
        } else if (AdType.AIQIYI.name().equals(param.getType())) {
            callbackUrl = this.buildAiqiyiCallback(param.getCallback());
            this.okHttpService.get(callbackUrl, (Map)Maps.newHashMap());
        }
        this.redisStringAdapter.remove(key);
        log.info("\u7528\u6237\u6fc0\u6d3b\u6210\u529f,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        return true;
    }

    private String buildBaiduCallbackUrl(String callback) {
        String callBack = StringUtils.replace((String)callback, (String)"{{ATYPE}}", (String)"activate");
        callBack = StringUtils.replace((String)callBack, (String)"{{AVALUE}}", (String)"0");
        callBack = callBack + "&akey=" + this.thirdPartyProperties.getBaiduAndroidKey();
        String sign = MD5Util.encode((String)callBack);
        callBack = callBack + "&sign=" + sign;
        return callBack;
    }

    private String buildAiqiyiCallback(String url) {
        url = url + "&event_type=0";
        String signature = MD5Util.encode((String)(url + this.thirdPartyProperties.getAiqiyiAndroidKey()));
        url = url + "&signature=" + signature;
        log.debug("\u7231\u5947\u827a\u56de\u8c03\u5730\u5740\uff1a{}", (Object)url);
        return url;
    }

    private static enum AdType {
        BAIDU,
        AIQIYI;

    }
}

