/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.config;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.thirdparty.config.CustomApacheHttpClientBuilder;
import com.bxm.localnews.thirdparty.config.WechatAccountConfig;
import com.bxm.localnews.thirdparty.config.WechatMPConfig;
import com.bxm.localnews.thirdparty.config.WechatMpServiceInvocationHandler;
import com.bxm.localnews.thirdparty.config.WxMpInRedisConfigStorage;
import com.bxm.localnews.thirdparty.dto.ActiveWechatMP;
import com.bxm.localnews.thirdparty.dto.WechatMP;
import com.bxm.localnews.thirdparty.dto.WechatMPDomainName;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WechatMpConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WechatMpConfiguration.class);
    private WechatMPConfig wechatMpConfig;
    private CustomApacheHttpClientBuilder customApacheHttpClientBuilder;
    private RedisStringAdapter redisStringAdapter;
    private WechatAccountConfig wechatAccountConfig;
    private static final String ACTIVE_APP_ID = "thirdparty.config.wechat.mp.active.active-app-id";
    private static final String ACTIVE_APP_DOMAIN_ID = "thirdparty.config.wechat.mp.active.active-domain-name-id";
    private WechatMpServiceInvocationHandler wechatMpServiceInvocationHandler = null;

    public WechatMpConfiguration(WechatMPConfig wechatMpConfig, CustomApacheHttpClientBuilder customApacheHttpClientBuilder, RedisStringAdapter redisStringAdapter, WechatAccountConfig wechatAccountConfig) {
        this.wechatMpConfig = wechatMpConfig;
        this.customApacheHttpClientBuilder = customApacheHttpClientBuilder;
        this.redisStringAdapter = redisStringAdapter;
        this.wechatAccountConfig = wechatAccountConfig;
    }

    @Bean
    public WxMpService wxMpService() {
        WxMpService wxMpService = this.createWxMpServiceWithMultiApp();
        this.wechatMpServiceInvocationHandler = new WechatMpServiceInvocationHandler(wxMpService, this.wechatMpConfig);
        return (WxMpService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{WxMpService.class}, (InvocationHandler)this.wechatMpServiceInvocationHandler);
    }

    private WxMpService createWxMpServiceWithMultiApp() {
        WxMpServiceImpl wxMpService = new WxMpServiceImpl();
        Map<String, WxMpConfigStorage> configStorages = JSON.parseArray((String)this.wechatMpConfig.getWechatMps(), WechatMP.class).stream().collect(Collectors.toMap(WechatMP::getAppId, this::buildWxMpConfigStorage));
        log.info("\u521d\u59cb\u5316\u7684\u5fae\u4fe1\u914d\u7f6e\u4fe1\u606f: {}", (Object)JSON.toJSONString(configStorages));
        wxMpService.setMultiConfigStorages(configStorages);
        return wxMpService;
    }

    private WxMpConfigStorage buildWxMpConfigStorage(WechatMP wechatMP) {
        WxMpInRedisConfigStorage wxConfigProvider = new WxMpInRedisConfigStorage(this.redisStringAdapter, this.customApacheHttpClientBuilder);
        wxConfigProvider.setAppId(wechatMP.getAppId());
        wxConfigProvider.setSecret(wechatMP.getAppSecret());
        wxConfigProvider.setAesKey(wechatMP.getAesKey());
        wxConfigProvider.setToken(wechatMP.getToken());
        return wxConfigProvider;
    }

    @Deprecated
    private ActiveWechatMP getActiveWechatMp() {
        if (Objects.isNull(this.wechatMpConfig.getActive())) {
            throw new RuntimeException("\u6ca1\u6709\u914d\u7f6e\u542f\u7528\u7684\u516c\u4f17\u53f7\u4fe1\u606f\uff01\uff01\uff01");
        }
        Optional<WechatMP> wechatMpOptional = JSON.parseArray((String)this.wechatMpConfig.getWechatMps(), WechatMP.class).stream().filter(p -> Objects.equals(p.getAppId(), this.wechatMpConfig.getActive().getActiveAppId())).findFirst();
        if (!wechatMpOptional.isPresent()) {
            log.error("appId: {} \u6ca1\u6709\u5bf9\u5e94\u7684\u516c\u4f17\u53f7\u914d\u7f6e", (Object)this.wechatMpConfig.getActive().getActiveAppId());
            throw new RuntimeException("\u516c\u4f17\u53f7\u914d\u7f6e\u7684appId\u6ca1\u6709\u53ef\u7528\u7684\u4fe1\u606f\uff01\uff01\uff01");
        }
        WechatMP wechatMp = wechatMpOptional.get();
        Optional<WechatMPDomainName> wechatMpDomainNameOptional = wechatMp.getDomainNames().stream().filter(p -> Objects.equals(p.getId(), this.wechatMpConfig.getActive().getActiveDomainNameId())).findFirst();
        if (!wechatMpDomainNameOptional.isPresent()) {
            log.error("\u57df\u540did: {} \u6ca1\u6709\u5bf9\u5e94\u7684\u57df\u540d\u4fe1\u606f", (Object)this.wechatMpConfig.getActive().getActiveDomainNameId());
            throw new RuntimeException("\u516c\u4f17\u53f7\u914d\u7f6e\u7684\u57df\u540did\u6ca1\u6709\u53ef\u7528\u7684\u4fe1\u606f\uff01\uff01\uff01");
        }
        return ActiveWechatMP.builder().appId(wechatMp.getAppId()).appSecret(wechatMp.getAppSecret()).domainName(wechatMpDomainNameOptional.get().getDomainName()).build();
    }

    @Deprecated
    private WxMpService createWxMpService() {
        WxMpServiceImpl wxMpService = new WxMpServiceImpl();
        wxMpService.setWxMpConfigStorage(this.wxConfigProvider());
        return wxMpService;
    }

    @Deprecated
    private WxMpConfigStorage wxConfigProvider() {
        WxMpInRedisConfigStorage wxConfigProvider = new WxMpInRedisConfigStorage(this.redisStringAdapter, this.customApacheHttpClientBuilder);
        ActiveWechatMP activeWechatMp = this.getActiveWechatMp();
        wxConfigProvider.setAppId(activeWechatMp.getAppId());
        wxConfigProvider.setSecret(activeWechatMp.getAppSecret());
        return wxConfigProvider;
    }

    @Deprecated
    public void changeHandler(ConfigChangeEvent configChangeEvent) {
        try {
            boolean changed = false;
            if (configChangeEvent.changedKeys().contains(ACTIVE_APP_ID)) {
                this.wechatMpConfig.getActive().setActiveAppId(configChangeEvent.getChange(ACTIVE_APP_ID).getNewValue());
                changed = true;
            }
            if (configChangeEvent.changedKeys().contains(ACTIVE_APP_DOMAIN_ID)) {
                this.wechatMpConfig.getActive().setActiveDomainNameId(Long.parseLong(configChangeEvent.getChange(ACTIVE_APP_DOMAIN_ID).getOldValue()));
                changed = true;
            }
            if (changed) {
                log.info("\u66f4\u6362\u4e86\u5fae\u4fe1\u516c\u4f17\u53f7\u914d\u7f6e\uff0c\u91cd\u65b0\u751f\u6210\u5e76\u66ff\u6362\u516c\u4f17\u53f7\u7ec4\u4ef6bean");
                this.wechatMpServiceInvocationHandler.setWxMpService(this.createWxMpService());
            }
        }
        catch (Exception e) {
            log.error("\u52a8\u6001\u66ff\u6362\u5fae\u4fe1\u516c\u4f17\u53f7\u7ec4\u4ef6Bean\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

