/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.config;

import cn.binarywang.wx.miniapp.config.WxMaInMemoryConfig;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.config.CustomApacheHttpClientBuilder;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaInRedisConfig
extends WxMaInMemoryConfig {
    private static final String ACCESS_TOKEN_KEY = "wechat_applet_access_token_";
    private static final String JSAPI_TICKET_KEY = "wechat_applet_jsapi_ticket_";
    private static final String CARDAPI_TICKET_KEY = "wechat_applet_cardapi_ticket_";
    private static final Logger logger = LoggerFactory.getLogger(WxMaInRedisConfig.class);
    private RedisStringAdapter redisStringAdapter;
    private String accessTokenKey;
    private String jsapiTicketKey;
    private String cardapiTicketKey;
    private CustomApacheHttpClientBuilder customApacheHttpClientBuilder;

    public WxMaInRedisConfig(RedisStringAdapter redisStringAdapter, CustomApacheHttpClientBuilder customApacheHttpClientBuilder) {
        this.redisStringAdapter = redisStringAdapter;
        this.customApacheHttpClientBuilder = customApacheHttpClientBuilder;
        this.setApacheHttpClientBuilder(customApacheHttpClientBuilder);
    }

    public void setAppid(String appId) {
        super.setAppid(appId);
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(appId);
        this.jsapiTicketKey = JSAPI_TICKET_KEY.concat(appId);
        this.cardapiTicketKey = CARDAPI_TICKET_KEY.concat(appId);
    }

    private KeyGenerator getWxMaKey(String key) {
        return RedisConfig.WEIXIN_KEY.copy().appendKey((Object)key);
    }

    public void expireAccessToken() {
        this.redisStringAdapter.remove(this.getWxMaKey(this.accessTokenKey));
        super.expireAccessToken();
    }

    public String getAccessToken() {
        return this.redisStringAdapter.getString(this.getWxMaKey(this.accessTokenKey));
    }

    public boolean isAccessTokenExpired() {
        return this.redisStringAdapter.hasKey(this.getWxMaKey(this.accessTokenKey)) == false;
    }

    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.redisStringAdapter.set(this.getWxMaKey(this.accessTokenKey), (Object)accessToken, (long)(expiresInSeconds - 200));
    }
}

