/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.UserRegisterInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.constant.AdvertShowTypeEnum;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAdvertFilterHandler {
    private static final Logger log = LogManager.getLogger(AbstractAdvertFilterHandler.class);
    @Autowired
    RedisStringAdapter redisStringAdapter;
    @Autowired
    private UserIntegrationService userIntegrationService;

    public boolean filter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        if (null == param) {
            return false;
        }
        return this.doFilter(advertVOS, param);
    }

    protected abstract boolean doFilter(List<AdvertVO> var1, AdvertisementParam var2);

    protected Boolean checkRemoveAdvertInfo(Long userId, Long advertId, Byte showType) {
        if (Boolean.TRUE.equals(this.redisStringAdapter.hasKey(this.getAdvertByTypeKey(showType, userId, advertId)))) {
            return true;
        }
        if (showType != null) {
            if (showType.byteValue() == AdvertShowTypeEnum.DAY_FIRST_OPEN_APP_SHOW.getCode()) {
                this.redisStringAdapter.set(this.getAdvertByTypeKey(showType, userId, advertId), (Object)userId, (long)DateUtils.getCurSeconds());
            } else {
                if (showType.byteValue() == AdvertShowTypeEnum.NEW_USER_SHOW_ONCE.getCode()) {
                    this.redisStringAdapter.set(this.getAdvertByTypeKey(showType, userId, advertId), (Object)userId);
                    UserRegisterInfoDTO userRegisterInfoDTO = this.userIntegrationService.userRegisterInfo(userId);
                    return userRegisterInfoDTO.getFirstLoginTime() == null || !org.apache.commons.lang3.time.DateUtils.isSameDay((Date)userRegisterInfoDTO.getFirstLoginTime(), (Date)new Date());
                }
                if (showType.byteValue() == AdvertShowTypeEnum.NOT_JOIN_LOTTERY_OLD_USER.getCode()) {
                    this.redisStringAdapter.set(this.getAdvertByTypeKey(showType, userId, advertId), (Object)userId);
                    UserRegisterInfoDTO userRegisterInfoDTO = this.userIntegrationService.userRegisterInfo(userId);
                    if (userRegisterInfoDTO.getFirstLoginTime() == null || org.apache.commons.lang3.time.DateUtils.isSameDay((Date)userRegisterInfoDTO.getFirstLoginTime(), (Date)new Date())) {
                        return true;
                    }
                    UserInfoDTO userFromRedisDB = this.userIntegrationService.getUserFromRedisDB(userId);
                    return Objects.isNull(userFromRedisDB) || BitOperatorUtil.getBitAsBoolean((Long)userFromRedisDB.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.JOINED_LOTTERY.getIndex());
                }
                this.redisStringAdapter.set(this.getAdvertByTypeKey(showType, userId, advertId), (Object)userId);
            }
        }
        return false;
    }

    private KeyGenerator getAdvertByTypeKey(Byte showType, Long userId, Long advertId) {
        return RedisConfig.THIRDPARTY_SHOW_TYPE_ADVERT.copy().appendKey((Object)(advertId + "_" + showType + "_" + userId));
    }
}

