/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.UserRegisterInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.enums.DeliveryCrowdEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdverFilter
public class DeliveryCrowdAdverFilter
extends AbstractAdvertFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(DeliveryCrowdAdverFilter.class);
    private final UserIntegrationService userIntegrationService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        ArrayList newAdvertList = new ArrayList();
        AtomicReference newUser = new AtomicReference();
        AtomicReference isVip = new AtomicReference();
        AtomicReference taokNovice = new AtomicReference();
        UserInfoDTO userInfo = param.getUserInfo();
        if (Objects.isNull(userInfo)) {
            UserInfoDTO userFromRedisDB = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
            param.setUserInfo(userFromRedisDB);
            userInfo = userFromRedisDB;
        }
        UserInfoDTO finalUserInfo = userInfo;
        if (Objects.isNull(userInfo)) {
            return true;
        }
        advertVOS.forEach(advertVO -> {
            if (advertVO.getDeliveryCrowd() == null || Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.ALL_CROWD.getType())) {
                newAdvertList.add(advertVO);
            }
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.NEW_USER.getType())) {
                if (Objects.isNull(newUser.get())) {
                    newUser.set(this.initNewUserInfo(param.getUserId()));
                }
                if (Objects.equals(newUser.get(), Boolean.TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.OLD_USER.getType())) {
                if (Objects.isNull(newUser.get())) {
                    newUser.set(this.initNewUserInfo(param.getUserId()));
                }
                if (!Objects.equals(newUser.get(), Boolean.TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.VIP_USER.getType())) {
                if (Objects.isNull(isVip.get())) {
                    isVip.set(this.userIntegrationService.checkUserIsVip(param.getUserId()));
                }
                if (Objects.equals(isVip.get(), Boolean.TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.NO_VIP_USER.getType())) {
                if (Objects.isNull(isVip.get())) {
                    isVip.set(this.userIntegrationService.checkUserIsVip(param.getUserId()));
                }
                if (!Objects.equals(isVip.get(), Boolean.TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.TK_NEW_CROWD.getType())) {
                if (Objects.isNull(taokNovice.get())) {
                    taokNovice.set(this.taokNew(finalUserInfo));
                }
                if (Objects.equals(taokNovice.get(), Boolean.TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.TK_CROWD.getType())) {
                if (Objects.isNull(taokNovice.get())) {
                    taokNovice.set(this.taokNew(finalUserInfo));
                }
                if (!Objects.equals(taokNovice.get(), Boolean.TRUE)) {
                    newAdvertList.add(advertVO);
                }
            }
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.TALENT.getType()) && !Objects.equals(finalUserInfo.getTalentLevel(), 0)) {
                newAdvertList.add(advertVO);
            }
            if (Objects.equals(advertVO.getDeliveryCrowd(), DeliveryCrowdEnum.NO_TALENT.getType()) && Objects.equals(finalUserInfo.getTalentLevel(), 0)) {
                newAdvertList.add(advertVO);
            }
        });
        advertVOS.clear();
        advertVOS.addAll(newAdvertList);
        return true;
    }

    private boolean initNewUserInfo(Long userId) {
        Date firstLoginDate;
        UserRegisterInfoDTO userRegisterInfoDTO = this.userIntegrationService.userRegisterInfo(userId);
        boolean newUser = userRegisterInfoDTO != null ? (firstLoginDate = userRegisterInfoDTO.getFirstLoginTime()) != null && DateUtils.isSameDay((Date)firstLoginDate, (Date)new Date()) : false;
        return newUser;
    }

    private boolean taokNew(UserInfoDTO userInfo) {
        return Objects.isNull(userInfo.getJudgeMarker()) || !BitOperatorUtil.getBitAsBoolean((Long)userInfo.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.HAS_ORDERED.getIndex());
    }

    public DeliveryCrowdAdverFilter(UserIntegrationService userIntegrationService) {
        this.userIntegrationService = userIntegrationService;
    }
}

