/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.constant.AdvertTypeEnum;
import com.bxm.localnews.thirdparty.enums.FollowActEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy.TopShowcaseContextProcess;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdverFilter(value={AdvertTypeEnum.TOP_SHOWCASE})
public class TopShowcaseAdvertFilter
extends AbstractAdvertFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(TopShowcaseAdvertFilter.class);
    private final TopShowcaseContextProcess contextProcess;
    private final AdverProperties adverProperties;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        advertVOS.removeIf(advert -> this.removeSpecificType((AdvertVO)advert, param));
        if (advertVOS.size() > this.adverProperties.getTopShowcaseMaxSize()) {
            ArrayList<AdvertVO> newAdvertList = new ArrayList<AdvertVO>();
            for (int advertLength = 0; advertLength < this.adverProperties.getTopShowcaseMaxSize(); ++advertLength) {
                AdvertVO advertVO = advertVOS.get(advertLength);
                newAdvertList.add(advertVO);
                if (!Objects.equals(advertVO.getFollowAct(), FollowActEnum.JUMP_HALF_OFF_GOODS.getType())) continue;
                advertVO.setFollowAct(FollowActEnum.JUMP_ZERO_BUY.getType());
            }
            advertVOS.clear();
            advertVOS.addAll(newAdvertList);
        }
        return true;
    }

    private boolean removeSpecificType(AdvertVO advertVO, AdvertisementParam param) {
        return this.contextProcess.removeInfo(advertVO, param);
    }

    public TopShowcaseAdvertFilter(TopShowcaseContextProcess contextProcess, AdverProperties adverProperties) {
        this.contextProcess = contextProcess;
        this.adverProperties = adverProperties;
    }
}

