/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.thirdparty.advert.annotation.AdverFilter;
import com.bxm.localnews.thirdparty.enums.FollowActEnum;
import com.bxm.localnews.thirdparty.filter.AbstractAdvertFilterHandler;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdverFilter
public class WeekHotPostRankAdverFilter
extends AbstractAdvertFilterHandler {
    private static final Logger log = LoggerFactory.getLogger(WeekHotPostRankAdverFilter.class);
    private final DomainIntegrationService domainIntegrationService;

    @Override
    protected boolean doFilter(List<AdvertVO> advertVOS, AdvertisementParam param) {
        advertVOS.forEach(advertVO -> {
            if (Objects.equals(advertVO.getFollowAct(), FollowActEnum.WEEK_HOT_POST_RANK.getType())) {
                if (Objects.equals(param.getChnl(), "outsideregister")) {
                    String hotPostUrl = "shareNewsTop.html";
                    advertVO.setFollowContent(this.domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.CONTENT_VIEW) + hotPostUrl);
                    advertVO.setAddress(this.domainIntegrationService.getOutSideShareBaseUrl(DomainScene.DomainViewScene.CONTENT_VIEW) + hotPostUrl);
                } else {
                    advertVO.setFollowContent("wst://community/hotPostRankList");
                    advertVO.setAddress("wst://community/hotPostRankList");
                }
            }
        });
        return true;
    }

    public WeekHotPostRankAdverFilter(DomainIntegrationService domainIntegrationService) {
        this.domainIntegrationService = domainIntegrationService;
    }
}

