/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.dto.TopShowcaseDTO;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.enums.FollowActEnum;
import com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy.TopShowcaseStrategy;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.thirdparty.vo.TopShowcaseExtDataAdver;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HalfOffVipStrategy
extends TopShowcaseStrategy {
    private static final Logger log = LoggerFactory.getLogger(HalfOffVipStrategy.class);
    private final AdverProperties adverProperties;
    private final BaseUrlFacadeService baseUrlFacadeService;
    private final MerchantIntegrationService merchantIntegrationService;

    @Override
    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {
        TopShowcaseDTO activityGoodsInfo = this.merchantIntegrationService.getActivityGoodsInfo(param.getAreaCode());
        if (activityGoodsInfo == null) {
            log.info("\u83b7\u53d65\u6298\u4f1a\u5458\u65e5/\u4f18\u60e0\u56e2\u8d2d\u6d3b\u52a8\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u6b64\u7d20\u6750");
            return true;
        }
        TopShowcaseExtDataAdver halfOffGoodsExtData = new TopShowcaseExtDataAdver();
        halfOffGoodsExtData.setImg(activityGoodsInfo.getImg());
        String price = null;
        try {
            price = activityGoodsInfo.getPrice().stripTrailingZeros().toPlainString();
            halfOffGoodsExtData.setPrice(new BigDecimal(price));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d65\u6298\u4f1a\u5458\u65e5/\u4f18\u60e0\u56e2\u8d2d\u6d3b\u52a8\u5546\u54c1\u4ef7\u683c\u8f6c\u6362\u9519\u8bef: [{}],\u9519\u8bef\u4fe1\u606f", (Object)activityGoodsInfo, (Object)e);
            return true;
        }
        halfOffGoodsExtData.setJumpUrl(this.baseUrlFacadeService.getInnerH5BaseUrl() + this.adverProperties.getHalfOffVipUrl());
        advertVO.setExtData((Object)halfOffGoodsExtData);
        return false;
    }

    @Override
    public Integer getType() {
        return FollowActEnum.JUMP_HALF_OFF_GOODS.getType();
    }

    public HalfOffVipStrategy(AdverProperties adverProperties, BaseUrlFacadeService baseUrlFacadeService, MerchantIntegrationService merchantIntegrationService) {
        this.adverProperties = adverProperties;
        this.baseUrlFacadeService = baseUrlFacadeService;
        this.merchantIntegrationService = merchantIntegrationService;
    }
}

