/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.dto.LotteryDetailFacadeDTO;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.thirdparty.config.AdverProperties;
import com.bxm.localnews.thirdparty.enums.FollowActEnum;
import com.bxm.localnews.thirdparty.filter.position.topShowcaseStrategy.TopShowcaseStrategy;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.bxm.localnews.thirdparty.vo.TopShowcaseExtDataAdver;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RedFlowerStrategy
extends TopShowcaseStrategy {
    private static final Logger log = LoggerFactory.getLogger(RedFlowerStrategy.class);
    private final MerchantIntegrationService merchantIntegrationService;
    private final AdverProperties adverProperties;
    private final BaseUrlFacadeService baseUrlFacadeService;

    @Override
    public Boolean removeInfo(AdvertVO advertVO, AdvertisementParam param) {
        LotteryDetailFacadeDTO lotteryInfo = this.merchantIntegrationService.getLotteryInfo(param.getAreaCode());
        if (lotteryInfo == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u7ea2\u82b1\u593a\u5b9d\u4fe1\u606f\u4e0d\u5b58\u5728\uff0cbanner\u4f4d\u5220\u9664\u6b64\u6570\u636e");
            }
            return true;
        }
        String jumpUrl = this.baseUrlFacadeService.getInnerH5BaseUrl() + this.adverProperties.getFlowerGainTreasureUrl();
        TopShowcaseExtDataAdver flowerGainTreasureAdver = new TopShowcaseExtDataAdver();
        flowerGainTreasureAdver.setImg(lotteryInfo.getImg());
        flowerGainTreasureAdver.setJumpUrl(jumpUrl);
        String price = null;
        try {
            price = lotteryInfo.getPrice().stripTrailingZeros().toPlainString();
            flowerGainTreasureAdver.setPrice(new BigDecimal(price));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ea2\u82b1\u593a\u5b9d\u6d3b\u52a8\u5546\u54c1\u4ef7\u683c\u8f6c\u6362\u9519\u8bef: [{}],\u9519\u8bef\u4fe1\u606f", (Object)lotteryInfo, (Object)e);
            return true;
        }
        advertVO.setExtData((Object)flowerGainTreasureAdver);
        return false;
    }

    @Override
    public Integer getType() {
        return FollowActEnum.JUMP_RED_FLOWER.getType();
    }

    public RedFlowerStrategy(MerchantIntegrationService merchantIntegrationService, AdverProperties adverProperties, BaseUrlFacadeService baseUrlFacadeService) {
        this.merchantIntegrationService = merchantIntegrationService;
        this.adverProperties = adverProperties;
        this.baseUrlFacadeService = baseUrlFacadeService;
    }
}

