/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.localnews.common.constant.AdvertMaterialType;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.BXMAdvertisementProperties;
import com.bxm.localnews.thirdparty.param.AdvertisementParam;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.req.AdReq;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.req.AppReq;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.req.BXMAdvertisementReq;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.req.DeviceReq;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.req.UserReq;
import com.bxm.localnews.thirdparty.param.bxm.advertisement.resp.BXMAdvertisementResp;
import com.bxm.localnews.thirdparty.service.AdvertisementFillService;
import com.bxm.localnews.thirdparty.vo.AdvertVO;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BXMAdvertisementFillService
implements AdvertisementFillService {
    private static final Logger log = LoggerFactory.getLogger(BXMAdvertisementFillService.class);
    @Autowired
    private OKHttpService okHttpService;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private BXMAdvertisementProperties bxmAdvertisementProperties;
    private static final Map<String, String> HEADER = Maps.newHashMap();

    @Override
    public void fill(AdvertisementParam param, List<AdvertVO> advertList) {
        UserInfoDTO user = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        UserReq userReq = null;
        if (Objects.nonNull(user)) {
            userReq = new UserReq();
            userReq.setGender(this.convertGender(user.getSex()));
            userReq.setId(Objects.toString(user.getId()));
            userReq.setKeywords(null);
        }
        UserReq userReqF = userReq;
        advertList.forEach(p -> {
            AdReq ext = new AdReq();
            p.setExt(JSON.toJSONString(Arrays.asList(ext)));
            if (Objects.equals(p.getMaterialType(), (byte)AdvertMaterialType.BXM_SSP_ADVERT.getType()) && StringUtils.isNotBlank((CharSequence)p.getExt())) {
                List adReqs = JSON.parseArray((String)p.getExt(), AdReq.class);
                BXMAdvertisementReq req = new BXMAdvertisementReq();
                AppReq appReq = null;
                DeviceReq deviceReq = null;
                if (Objects.nonNull(param.getApp())) {
                    appReq = new AppReq();
                    BeanUtils.copyProperties((Object)param.getApp(), (Object)appReq);
                }
                if (Objects.nonNull(param.getDevice())) {
                    deviceReq = new DeviceReq();
                    BeanUtils.copyProperties((Object)param.getDevice(), (Object)deviceReq);
                }
                req.setVer(param.getCurVer());
                req.setApp(appReq);
                req.setDevice(deviceReq);
                req.setUser(userReqF);
                req.setAds(adReqs);
                req.setTest(this.bxmAdvertisementProperties.getTest());
                req.setHttps(this.bxmAdvertisementProperties.getHttps());
                req = (BXMAdvertisementReq)JSON.parseObject((String)this.bxmAdvertisementProperties.getBxmSspReq(), BXMAdvertisementReq.class);
                try {
                    BXMAdvertisementResp bxmAdvertisementResp;
                    String reqStr = JSON.toJSONString((Object)req);
                    if (log.isDebugEnabled()) {
                        log.debug("\u8bf7\u6c42\u53d8\u73b0\u732bSSP\u63a5\u53e3\u53c2\u6570: {}", (Object)reqStr);
                    }
                    String result = this.okHttpService.postJsonBody("http://47.98.242.33:1892/bidding/bxm", reqStr, HEADER);
                    if (log.isDebugEnabled()) {
                        log.debug("\u8bf7\u6c42\u53d8\u73b0\u732bSSP\u63a5\u53e3\u8fd4\u56de\u6570\u636e: {}", (Object)result);
                    }
                    if (!(!StringUtils.isNotBlank((CharSequence)result) || Objects.nonNull(bxmAdvertisementResp = (BXMAdvertisementResp)JSON.parseObject((String)result, BXMAdvertisementResp.class)) && Objects.equals(bxmAdvertisementResp.getResult(), 0))) {
                        log.warn("\u8bf7\u6c42\u53d8\u73b0\u732bSSP\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570: {}\uff0c \u8fd4\u56de\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)req), (Object)result);
                    }
                }
                catch (Exception e) {
                    log.error("\u8bf7\u6c42\u53d8\u73b0\u732bSSP\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38, \u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)req), (Object)e);
                }
            }
        });
    }

    private Integer convertGender(Byte sex) {
        if (Objects.isNull(sex)) {
            return 0;
        }
        switch (sex) {
            case 0: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 3;
    }

    public static void main(String[] args) {
        OKHttpService service = new OKHttpService();
        String result = service.postJsonBody("http://47.98.242.33:1892/bidding/bxm", "{\"ver\":\"0.1.1\",\"app\":{\"name\":\"wst\",\"bundle\":\"wangshitong\",\"ver\":\"3.0.0\"},\"device\":{\"os\":\"android\",\"os_version\":\"Lollipop\",\"model\":\"redmi\",\"ip\":\"115.206.13.64\",\"make\":\"mi\",\"brand\":\"mi\",\"connection_type\":1,\"orientation\":1,\"ua\":\"Mozilla/5.0 (Linux; U; Android 8.1.0; zh-cn; MI 5X Build/OPM1.171019.019) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/61.0.3163.128 Mobile Safari/537.36 XiaoMi/MiuiBrowser/10.8.3\",\"imei\":\"ersltb3B1Yi1pb35NyDA31A0oabakBiJkfI42\",\"screen\":{\"w\":400,\"h\":1000}},\"ads\":[{\"floor_price\":1,\"w\":\"300\",\"h\":\"300\",\"place_token\":\"quanping\"}],\"test\":1}", HEADER);
        System.out.println(result);
    }

    static {
        HEADER.put("Content-Type", "application/json");
    }
}

