/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.common.config.ClientConfigProperties;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.rediskey.UserRedisKey;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.ImIntegrationService;
import com.bxm.localnews.integration.NewsIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.BatchMessageParam;
import com.bxm.localnews.param.ForumPostFacadeParam;
import com.bxm.localnews.param.UserFollowTypeParam;
import com.bxm.localnews.thirdparty.config.PopupProperties;
import com.bxm.localnews.thirdparty.constant.RedisLockKey;
import com.bxm.localnews.thirdparty.param.GuideCloseParam;
import com.bxm.localnews.thirdparty.param.GuideStatusParam;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.GuidePopService;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.AbstractPopStrategy;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.PopOnceStrategy;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.localnews.vo.PostImgVo;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.BasicParam;
import com.gexin.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GuidePopServiceImpl
implements GuidePopService {
    private static final Logger log = LoggerFactory.getLogger(GuidePopServiceImpl.class);
    @Autowired
    private PopOnceStrategy popOnceStrategy;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private PopupProperties popupProperties;
    @Autowired
    private ImIntegrationService imIntegrationService;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private LocationFacadeService locationFacadeService;
    @Autowired
    private BizLogService bizLogService;
    @Autowired
    private NewsIntegrationService newsIntegrationService;
    @Autowired
    private ClientConfigProperties clientConfigProperties;
    @Autowired
    private DistributedLock lock;
    @Autowired
    private SequenceCreater sequenceCreater;
    private static final String USER_NAME = "{userName}";
    private static final String AREA_NAME = "{areaName}";

    @Override
    public boolean guideStatus(GuideStatusParam param) {
        if (Objects.isNull(param.getType())) {
            log.warn("\u83b7\u53d6\u5f39\u7a97\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u6709\u8bef param: {}", (Object)JSON.toJSONString((Object)param));
            return false;
        }
        Optional<PopTypeEnum> byType = PopTypeEnum.getByType(param.getType());
        if (!byType.isPresent()) {
            log.warn("\u83b7\u53d6\u5f39\u7a97\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u6709\u8bef param: {}", (Object)JSON.toJSONString((Object)param));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCurVer()) && com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan((String)param.getCurVer(), (String)"3.6.0") && !Objects.equals((Object)byType.get(), (Object)PopTypeEnum.MINE_INVITE_POP)) {
            log.info("3.6.0\u4e4b\u540e\u7684\u7248\u672c\uff0c\u4e14\u4e0d\u662f\u6211\u7684\u9875\u9762\u7684\u5f39\u7a97\u7c7b\u578b\uff0c\u4e0d\u5f39\u51fa param: {}", (Object)JSON.toJSONString((Object)param));
            return false;
        }
        LocationDetailDTO locationDetailByCode = this.locationFacadeService.getLocationDetailByCode(param.getAreaCode());
        if (Objects.isNull(locationDetailByCode) || !Objects.equals(locationDetailByCode.getEnableCommunityContent(), 1)) {
            if (log.isDebugEnabled()) {
                log.debug("\u57ce\u5e02: {} \u672a\u5f00\u901a\uff0c\u8fd4\u56de\u4e0d\u5f39\u51fa\u5f15\u5bfc\u5f39\u7a97", (Object)param.getAreaCode());
            }
            return false;
        }
        UserInfoDTO userFromRedisDB = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userFromRedisDB) || Objects.isNull(userFromRedisDB.getJudgeMarker()) || Objects.equals(Boolean.FALSE, BitOperatorUtil.getBitAsBoolean((Long)userFromRedisDB.getJudgeMarker(), (int)LocalNewsUserJudgeMarkerEnum.VER_3_5_0.getIndex()))) {
            log.info("\u7528\u6237: {} \u662f\u8001\u7248\u672c\u6ce8\u518c\u7528\u6237 \u4e0d\u5f39\u51fa\u5f15\u5bfc\u5f39\u7a97", (Object)param.getUserId());
            return false;
        }
        this.specialPositionPopUp(byType.get(), param);
        PopCache popCache = (PopCache)this.redisHashMapAdapter.get(AbstractPopStrategy.getRedisKey(param.getUserId()), byType.get().name(), PopCache.class);
        return Objects.isNull(popCache) || popCache.isPopUp();
    }

    private void specialPositionPopUp(PopTypeEnum popType, GuideStatusParam param) {
        String info;
        if (this.specialPosition(popType) && StringUtils.isNotBlank((CharSequence)(info = (String)this.redisHashMapAdapter.get(UserRedisKey.HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()), String.class)))) {
            if (Objects.equals("1", info)) {
                this.cacheGuidePopup(param.getUserId(), PopTypeEnum.MINE_INVITE_POP.getType(), true);
                this.cacheGuidePopup(param.getUserId(), PopTypeEnum.VIP_POSITION_POP.getType(), true);
                this.redisHashMapAdapter.put(UserRedisKey.HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()), (Object)"3");
            } else if (Objects.equals("2", info)) {
                this.cacheGuidePopup(param.getUserId(), PopTypeEnum.MINE_INVITE_POP.getType(), true);
                this.redisHashMapAdapter.put(UserRedisKey.HASH_USER_ACTIVE_VIP_FIRST, String.valueOf(param.getUserId()), (Object)"3");
            }
        }
    }

    private boolean specialPosition(PopTypeEnum popType) {
        return Objects.equals((Object)popType, (Object)PopTypeEnum.MINE_INVITE_POP) || Objects.equals((Object)popType, (Object)PopTypeEnum.VIP_POSITION_POP);
    }

    @Override
    public void guideClose(GuideCloseParam closeParam) {
        String key = RedisLockKey.CLOSE_POPUP.copy().appendKey((Object)closeParam.getUserId()).appendKey((Object)closeParam.getType()).gen();
        if (!this.lock.lock(key, this.sequenceCreater.nextStringId())) {
            log.warn("\u7528\u6237: {} \u91cd\u590d\u70b9\u51fb\u5f39\u7a97: {} ", (Object)closeParam.getUserId(), (Object)closeParam.getType());
            return;
        }
        this.cacheGuidePopup(closeParam.getUserId(), closeParam.getType(), false);
        this.afterSpecialGuideClose(closeParam);
    }

    private void cacheGuidePopup(Long userId, Integer type, boolean open) {
        if (Objects.isNull(type)) {
            log.warn("\u5173\u95ed\u5f39\u7a97\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u6709\u8bef userId: {} type: {}", (Object)userId, (Object)type);
            return;
        }
        Optional<PopTypeEnum> popType = PopTypeEnum.getByType(type);
        if (!popType.isPresent()) {
            log.warn("\u5173\u95ed\u5f39\u7a97\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u6709\u8bef userId: {} type: {}", (Object)userId, (Object)type);
            return;
        }
        PopContext context = new PopContext();
        HomeWindowParam param = new HomeWindowParam();
        param.setUserId(userId);
        context.setHomeWindowParam(param);
        context.getParamMap().put("key", popType.get().name());
        PopCache cache = new PopCache();
        cache.addParam("num", 1);
        cache.setPopUp(open);
        context.setCacheMap(Maps.newHashMap());
        context.getCacheMap().put(popType.get().name(), cache);
        this.popOnceStrategy.cache(context);
    }

    private String getNormalNoviceUserGuideSentMsgContent(String areaCode) {
        if (CollectionUtils.isEmpty(this.popupProperties.getNormalNoviceUserGuideSentMsgContents()) || StringUtils.isBlank((CharSequence)areaCode)) {
            return this.popupProperties.getDefaultNormalNoviceUserGuideSentMsgContent();
        }
        LocationDetailDTO locationDetailDTO = this.locationFacadeService.getLocationDetailByCode(areaCode);
        if (Objects.isNull(locationDetailDTO)) {
            return this.popupProperties.getDefaultNormalNoviceUserGuideSentMsgContent();
        }
        String cityName = locationDetailDTO.getName();
        try {
            String str = this.popupProperties.getNormalNoviceUserGuideSentMsgContents().get(RandomUtils.nextInt((int)0, (int)this.popupProperties.getNormalNoviceUserGuideSentMsgContents().size()));
            return String.format(str, cityName);
        }
        catch (Exception e) {
            log.error("\u6a21\u677f\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            return this.popupProperties.getDefaultNormalNoviceUserGuideSentMsgContent();
        }
    }

    private String getVipNoviceUserGuideSentMsgContent() {
        if (CollectionUtils.isEmpty(this.popupProperties.getVipNoviceUserGuideSentMsgContents())) {
            return "\u6211\u5df2\u7ecf\u6210\u529f\u9886\u53d6\u4f60\u8d60\u9001\u7684VIP\u5361\u5566\uff0c\u611f\u8c22\u4f60\u54e6~";
        }
        try {
            return this.popupProperties.getVipNoviceUserGuideSentMsgContents().get(RandomUtils.nextInt((int)0, (int)this.popupProperties.getVipNoviceUserGuideSentMsgContents().size()));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6a21\u677f\u5931\u8d25", (Throwable)e);
            return "\u6211\u5df2\u7ecf\u6210\u529f\u9886\u53d6\u4f60\u8d60\u9001\u7684VIP\u5361\u5566\uff0c\u611f\u8c22\u4f60\u54e6~";
        }
    }

    private void afterSpecialGuideClose(GuideCloseParam param) {
        BatchMessageParam messageParam = new BatchMessageParam();
        messageParam.setObjectName("RC:TxtMsg");
        messageParam.setFromUserId(param.getUserId());
        boolean follow = false;
        if (Objects.equals(PopTypeEnum.NORMAL_GUIDE_POP.getType(), param.getType())) {
            messageParam.setContent(this.getNormalNoviceUserGuideSentMsgContent(param.getAreaCode()));
            follow = true;
            this.cacheOutGuidePopup(param);
            this.postNovicePost(param);
        } else if (Objects.equals(PopTypeEnum.VIP_GUIDE_POP.getType(), param.getType())) {
            messageParam.setContent(this.getVipNoviceUserGuideSentMsgContent());
        } else {
            return;
        }
        UserInfoDTO userInfo = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userInfo)) {
            log.warn("\u7528\u6237: {}\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7ed9\u4e0a\u7ea7\u53d1\u9001\u79c1\u804a\u6d88\u606f", (Object)param.getUserId());
            return;
        }
        if (Objects.isNull(userInfo.getInviteUserId())) {
            log.info("\u7528\u6237: {} \u6ca1\u6709\u9080\u8bf7\u4eba\u4fe1\u606f\uff0c\u65e0\u6cd5\u7ed9\u4e0a\u7ea7\u53d1\u9001\u79c1\u804a\u6d88\u606f", (Object)param.getUserId());
            return;
        }
        messageParam.setToUserId(Collections.singletonList(userInfo.getInviteUserId()));
        this.imIntegrationService.sendMsg(messageParam);
        PointReportParam reportParam = PointReportParam.build((com.bxm.localnews.common.vo.BasicParam)param).e("3034").ev("123." + userInfo.getInviteUserId()).put("uid", String.valueOf(userInfo.getId()));
        this.bizLogService.report(reportParam);
        if (follow) {
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237: {} \u4e0a\u7ea7: {}\u8fdb\u884c\u76f8\u4e92\u5173\u6ce8", (Object)param.getUserId(), (Object)userInfo.getInviteUserId());
            }
            UserFollowTypeParam followParam = new UserFollowTypeParam();
            followParam.setFromUserId(param.getUserId());
            followParam.setToUserId(userInfo.getInviteUserId());
            followParam.setType(Byte.valueOf((byte)0));
            this.userIntegrationService.follow(followParam);
            followParam = new UserFollowTypeParam();
            followParam.setFromUserId(userInfo.getInviteUserId());
            followParam.setToUserId(param.getUserId());
            followParam.setType(Byte.valueOf((byte)0));
            this.userIntegrationService.follow(followParam);
        }
    }

    private void cacheOutGuidePopup(GuideCloseParam param) {
        this.cacheGuidePopup(param.getUserId(), PopTypeEnum.HOME_CHANNEL_POP.getType(), false);
        this.cacheGuidePopup(param.getUserId(), PopTypeEnum.LOCAL_CYCLE_POP.getType(), false);
        this.cacheGuidePopup(param.getUserId(), PopTypeEnum.PLUS_POP.getType(), false);
        this.cacheGuidePopup(param.getUserId(), PopTypeEnum.MINE_INVITE_POP.getType(), false);
        this.cacheGuidePopup(param.getUserId(), PopTypeEnum.VIP_POSITION_POP.getType(), false);
    }

    private void postNovicePost(GuideCloseParam param) {
        if (com.bxm.newidea.component.tools.StringUtils.isGrateOrEqualThan((String)param.getCurVer(), (String)"3.6.0")) {
            LocationDetailDTO locationDetailByCode = this.locationFacadeService.getLocationDetailByCode(param.getAreaCode());
            String locationName = Objects.isNull(locationDetailByCode) ? "" : locationDetailByCode.getName();
            UserInfoDTO userInfo = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
            String publishContent = this.getPublishContent(userInfo, locationName);
            List<Object> postImg = Collections.emptyList();
            if (Objects.nonNull(userInfo)) {
                PostImgVo postImgVo = new PostImgVo();
                postImgVo.setType("IMG");
                postImgVo.setImgUrl(userInfo.getHeadImg());
                postImg = Collections.singletonList(postImgVo);
            }
            ForumPostFacadeParam facadeParam = new ForumPostFacadeParam();
            facadeParam.merge((BasicParam)param);
            facadeParam.setAreaCode(param.getAreaCode());
            facadeParam.setTopicIdList(Collections.singletonList(this.popupProperties.getNoviceTopicId()));
            facadeParam.setIsNewReport(Byte.valueOf((byte)1));
            facadeParam.setTitle("");
            facadeParam.setUserId(param.getUserId());
            facadeParam.setLocation(locationName);
            facadeParam.setTextField(publishContent);
            facadeParam.setPostImgList(postImg);
            log.info("\u7528\u6237: {} \u53d1\u9001\u65b0\u4eba\u5e16\u5b50\u4fe1\u606f: {}", (Object)param.getUserId(), (Object)JSON.toJSONString((Object)facadeParam));
            this.newsIntegrationService.createOrUpdatePost(facadeParam);
        }
    }

    private String getPublishContent(UserInfoDTO userInfo, String locationName) {
        List publishContents;
        String publishContent = "\u65b0\u4eba\u62a5\u5230\uff0c\u6765\u6df7\u4e2a\u773c\u719f\uff0c\u4ee5\u540e\u6211\u4f1a\u7ecf\u5e38\u51fa\u73b0~";
        if (Objects.nonNull(this.clientConfigProperties.getCommonKeys()) && Objects.nonNull(userInfo) && StringUtils.isNotBlank((CharSequence)locationName) && !CollectionUtils.isEmpty((Collection)(publishContents = com.alibaba.fastjson.JSON.parseArray((String)(publishContent = (String)this.clientConfigProperties.getCommonKeys().get("publishContent")), String.class)))) {
            publishContent = (String)publishContents.get(RandomUtils.nextInt((int)0, (int)publishContents.size()));
            publishContent = this.replaceKeyWord(publishContent, userInfo.getNickname(), locationName);
        }
        return publishContent;
    }

    private String replaceKeyWord(String str, String userName, String areaName) {
        if (str.contains(USER_NAME)) {
            str = str.replace(USER_NAME, userName);
        }
        if (str.contains(AREA_NAME)) {
            str = str.replace(AREA_NAME, areaName);
        }
        return str;
    }
}

