/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.thirdparty.config.ThirdpartyJumpInfoProperties;
import com.bxm.localnews.thirdparty.dto.OrderTabDTO;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.param.OrderTabsParam;
import com.bxm.localnews.thirdparty.service.impl.ThirdpartyJumpInfoService;
import com.bxm.localnews.thirdparty.service.jump.JumpInfoConvertService;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import com.bxm.localnews.thirdparty.vo.OrderTab;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdpartyJumpInfoServiceImpl
implements ThirdpartyJumpInfoService {
    private static final Logger log = LoggerFactory.getLogger(ThirdpartyJumpInfoServiceImpl.class);
    @Autowired
    private ThirdpartyJumpInfoProperties thirdpartyJumpInfoProperties;
    @Autowired
    private JumpInfoConvertService jumpInfoConvertService;
    private LoadingCache<String, List<OrderTab>> cache;

    @Override
    public List<OrderTabDTO> orderTabs(OrderTabsParam param) {
        List<OrderTab> orderTabs = this.convertTabs();
        return orderTabs.stream().filter(p -> p.getStatus().intValue() == 1).map(p -> {
            Optional<JumpInfo> jpInfoOptional = this.jumpInfoConvertService.convert(JumpInfoConvertParam.builder().basicParam((BasicParam)param).jumpType(p.getJumpType()).userId(param.getUserId()).build());
            if (jpInfoOptional.isPresent() && StringUtils.isNotBlank((CharSequence)jpInfoOptional.get().getProtocol())) {
                OrderTabDTO tabDTO = new OrderTabDTO();
                tabDTO.setJumpUrl(jpInfoOptional.get().getProtocol());
                tabDTO.setTitle(p.getTitle());
                tabDTO.setDefaultChose(p.getDefaultChose());
                tabDTO.setId(p.getId());
                return tabDTO;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<OrderTab> convertTabs() {
        if (Objects.isNull(this.cache)) {
            this.cache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, List<OrderTab>>(){

                public List<OrderTab> load(String key) throws Exception {
                    return ThirdpartyJumpInfoServiceImpl.this.thirdpartyJumpInfoProperties.getOrderTabs().stream().map(p -> (OrderTab)JSON.parseObject((String)p, OrderTab.class)).collect(Collectors.toList());
                }
            });
        }
        return (List)this.cache.getUnchecked((Object)"key");
    }
}

