/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaCodeLineColor;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.thirdparty.config.WechatMPConfig;
import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.config.WxMaConfiguration;
import com.bxm.localnews.thirdparty.constant.WxMaTypeEnum;
import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxMaUserData;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.thirdparty.vo.WechatBackResult;
import com.bxm.localnews.vo.User;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger logger = LoggerFactory.getLogger(WechatServiceImpl.class);
    private static final String BASE_SENSITIVE_WORD_URL = "https://api.weixin.qq.com/wxa/msg_sec_check?access_token=";
    private final RedisStringAdapter redisStringAdapter;
    private final WechatProperties wechatProperties;
    private final HttpClientService httpClientService;
    private final AliyunOSSService aliyunOSSService;
    private final UserIntegrationService userIntegrationService;
    private final UserAuthIntegrationService userAuthIntegrationService;
    private final RedisListAdapter redisListAdapter;
    private final WechatMPConfig wechatMpConfig;

    @Override
    public WxMaService getWxMaService(String appid) {
        if (StringUtils.isBlank((CharSequence)appid)) {
            appid = this.wechatProperties.getAppId();
        }
        return WxMaConfiguration.getMaService(appid);
    }

    @Override
    public WxUserInfo getWechatInfo(WechatDto wechatDto) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        String code = wechatDto.getCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            return wxUserInfo;
        }
        try {
            WxMaJscode2SessionResult wxMaJscode2SessionResult = this.getWxMaService(wechatDto.getAppId()).jsCode2SessionInfo(wechatDto.getCode());
            return this.convertWxMaResult(wxMaJscode2SessionResult, wxUserInfo, wechatDto.getType());
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u3010\u5927\u8f6c\u76d8\u3011\u6839\u636ecode\u83b7\u53d6openid\u9519\u8bef, [{}]", (Throwable)e);
            return wxUserInfo;
        }
    }

    private WxUserInfo convertWxMaResult(WxMaJscode2SessionResult wxMaJscode2SessionResult, WxUserInfo wxUserInfo, String type) {
        UserAuth userAuth;
        String openId = wxMaJscode2SessionResult.getOpenid();
        wxUserInfo.setOpenId(openId);
        wxUserInfo.setSessionKey(wxMaJscode2SessionResult.getSessionKey());
        wxUserInfo.setUnionId(wxMaJscode2SessionResult.getUnionid());
        if (StringUtils.isNotBlank((CharSequence)openId) && null != (userAuth = this.userAuthIntegrationService.selectAppletUserAuthByOpenId(openId, WxMaTypeEnum.valueOf((String)type).getType())) && null != userAuth.getUserId()) {
            wxUserInfo.setUserId(userAuth.getUserId());
            User user = this.userIntegrationService.selectByPrimaryKey(userAuth.getUserId());
            if (user != null) {
                wxUserInfo.setNickname(user.getNickname());
                wxUserInfo.setHeadImg(user.getHeadImg());
                wxUserInfo.setPhone(user.getPhone());
                wxUserInfo.setLocationCode(user.getLocationCode());
                wxUserInfo.setLocationName(user.getLocationName());
                if (StringUtils.isBlank((CharSequence)user.getWeixin())) {
                    wxUserInfo.setAuth(Boolean.valueOf(false));
                }
            }
        }
        return wxUserInfo;
    }

    @Override
    public String getWechatQRCode(WechatDto wechatDto) {
        WxMaCodeLineColor wxMaCodeLineColor = (WxMaCodeLineColor)JSON.parseObject((String)wechatDto.getLineColor(), WxMaCodeLineColor.class);
        try {
            if (StringUtils.isBlank((CharSequence)wechatDto.getScene())) {
                logger.info("\u524d\u7aef\u672a\u4f20\u9012scene\u503c\uff0c\u4f7f\u7528\u9ed8\u8ba4\u76841011\u3002\u53c2\u6570\u4e3a\uff1a[{}]", (Object)wechatDto);
                wechatDto.setScene("1011");
            }
            File file = this.getWxMaService(wechatDto.getAppId()).getQrcodeService().createWxaCodeUnlimit(wechatDto.getScene(), wechatDto.getPage(), wechatDto.getWidth().intValue(), wechatDto.getAutoColor().booleanValue(), wxMaCodeLineColor, wechatDto.getHyaline().booleanValue());
            String imgName = DateUtils.formatDate((Date)new Date()) + "/" + UUID.randomUUID() + "-" + wechatDto.getInviteUserId() + ".png";
            return this.aliyunOSSService.upload(file, "/qr/" + imgName);
        }
        catch (WxErrorException e) {
            logger.error("\u751f\u6210\u5c0f\u7a0b\u5e8f\u4e8c\u7ef4\u7801\u9519\u8bef,\u8bf7\u6c42\u53c2\u6570\uff1a[{}]", (Object)wechatDto);
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String createUser(WxMaUserData wxMaUserData) {
        logger.info("\u5c0f\u7a0b\u5e8f\u6388\u6743\u767b\u9646\uff1a\u89e3\u6790\u6570\u636e\uff1a[{}]", (Object)JSON.toJSONString((Object)wxMaUserData));
        WxMaUserInfo wxMaUserInfo = this.getWxMaService(wxMaUserData.getAppId()).getUserService().getUserInfo(wxMaUserData.getSessionKey(), wxMaUserData.getEncryptedData(), wxMaUserData.getIv());
        if (wxMaUserInfo != null) {
            UserParam userParam = this.convertUser(wxMaUserData, wxMaUserInfo);
            logger.info("\u521b\u5efa\u7684\u7528\u6237\u4fe1\u606f\uff1a[{}]", (Object)JSON.toJSONString((Object)userParam));
            Message message = null;
            if (WxMaTypeEnum.APPLET_DRAW.getName().equals(wxMaUserData.getType())) {
                logger.info("-------\u5927\u8f6c\u76d8\u5c0f\u7a0b\u5e8f\u521b\u5efa\u7528\u6237---");
                userParam.setInviteType(InviteTypeEnum.APPLETDRAW.getName());
                message = this.userIntegrationService.createUser(userParam);
            }
            if (WxMaTypeEnum.APPLET_WST.getName().equals(wxMaUserData.getType())) {
                logger.info("-------\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\u521b\u5efa\u7528\u6237---");
                userParam.setInviteType(InviteTypeEnum.MINI_WST.getName());
                message = this.userIntegrationService.updateUser(userParam);
            }
            if (message != null && message.isSuccess()) {
                logger.info("\u5c0f\u7a0b\u5e8f\u6388\u6743\u767b\u9646\u8fd4\u56de\u4fe1\u606f\uff1a[{}]", (Object)JSON.toJSONString((Object)message));
                return message.getParamMap().get("userId").toString();
            }
        }
        return "";
    }

    private UserParam convertUser(WxMaUserData wxMaUserData, WxMaUserInfo wxMaUserInfo) {
        UserParam userParam = new UserParam();
        userParam.setOpenId(wxMaUserInfo.getOpenId());
        userParam.setUnionId(wxMaUserInfo.getUnionId());
        userParam.setHeadImg(wxMaUserInfo.getAvatarUrl());
        userParam.setNickName(wxMaUserInfo.getNickName());
        userParam.setSex(Byte.valueOf(wxMaUserInfo.getGender()));
        userParam.setRegIp(wxMaUserData.getIp());
        userParam.setPlatform(wxMaUserData.getPlatform());
        userParam.setRegisteredAddress(wxMaUserData.getArea());
        userParam.setInviteUserId(wxMaUserData.getInviteUserId());
        userParam.setRelationId(wxMaUserData.getRelationId());
        userParam.setTaskInvited(wxMaUserData.getTaskInvited());
        userParam.setLocationCode(wxMaUserData.getLocationCode());
        userParam.setLocationName(wxMaUserData.getLocationName());
        return userParam;
    }

    @Override
    public Boolean setUserFormId(Long userId, String formId, String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = this.wechatProperties.getAppId();
        }
        KeyGenerator key = RedisConfig.WEIXIN_FORMID.copy().appendKey((Object)appId).appendKey((Object)userId);
        this.redisListAdapter.rightPush(key, (Object[])new String[]{formId});
        this.redisListAdapter.expire(key, 604800L);
        return true;
    }

    @Override
    public String getWeChatToken() {
        try {
            return this.getWxMaService(null).getAccessToken();
        }
        catch (WxErrorException e) {
            logger.error("\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7684appid\u5931\u8d25");
            return null;
        }
    }

    @Override
    public void emptyWeChatToken() {
    }

    @Override
    public Boolean userPopup(String openId, Integer platform) {
        if (this.redisStringAdapter.hasKey(this.getUserPopupKey(openId, platform)).booleanValue()) {
            return false;
        }
        this.redisStringAdapter.set(this.getUserPopupKey(openId, platform), (Object)1, (long)DateUtils.getCurSeconds());
        return true;
    }

    @Override
    public WxMaPhoneNumberInfo getUserPhoneNum(WxMaUserData wxMaUserData) {
        return this.getWxMaService(wxMaUserData.getAppId()).getUserService().getPhoneNoInfo(wxMaUserData.getSessionKey(), wxMaUserData.getEncryptedData(), wxMaUserData.getIv());
    }

    private KeyGenerator getUserPopupKey(String openId, Integer platform) {
        return RedisConfig.WX_APPLET_POPUP.copy().appendKey((Object)platform).appendKey((Object)"_").appendKey((Object)openId);
    }

    @Override
    public Boolean hasSensitiveWord(String content) {
        String accessToken = this.geAppletAccessToken();
        String url = BASE_SENSITIVE_WORD_URL + accessToken;
        JSONObject para = new JSONObject();
        para.put("content", (Object)content);
        String result = this.httpClientService.doPostJson(url, para.toJSONString());
        WechatBackResult backResult = (WechatBackResult)JSONObject.parseObject((String)result, WechatBackResult.class);
        return !WechatBackResult.SUCCESS_CODE.equals(backResult.getErrcode());
    }

    private String geAppletAccessToken() {
        String accessToken = null;
        try {
            accessToken = this.getWxMaService(this.wechatProperties.getWstAppId()).getAccessToken();
        }
        catch (WxErrorException e) {
            logger.error("\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7684access_token\u5931\u8d25");
        }
        return accessToken;
    }

    @Override
    public String getOfficialAccountAppId(String type) {
        Map<String, String> appIdByType = this.wechatMpConfig.getAppIdByType();
        return appIdByType.get(type);
    }

    @Autowired
    public WechatServiceImpl(RedisStringAdapter redisStringAdapter, WechatProperties wechatProperties, HttpClientService httpClientService, AliyunOSSService aliyunOSSService, UserIntegrationService userIntegrationService, UserAuthIntegrationService userAuthIntegrationService, RedisListAdapter redisListAdapter, WechatMPConfig wechatMpConfig) {
        this.redisStringAdapter = redisStringAdapter;
        this.wechatProperties = wechatProperties;
        this.httpClientService = httpClientService;
        this.aliyunOSSService = aliyunOSSService;
        this.userIntegrationService = userIntegrationService;
        this.userAuthIntegrationService = userAuthIntegrationService;
        this.redisListAdapter = redisListAdapter;
        this.wechatMpConfig = wechatMpConfig;
    }
}

