/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.VipInfoDetailDTO;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.UserVipIntegrationService;
import com.bxm.localnews.integration.WxOfficialAccountService;
import com.bxm.localnews.param.VipQueryParam;
import com.bxm.localnews.thirdparty.config.WechatAccountConfig;
import com.bxm.localnews.thirdparty.config.WechatMPConfig;
import com.bxm.localnews.thirdparty.constant.WechatMpTypeEnum;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WxMpAuthService;
import com.bxm.localnews.thirdparty.service.WxMpFacadeService;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import me.chanjar.weixin.mp.util.WxMpConfigStorageHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WxMpAuthServiceImpl
extends BaseService
implements WxMpAuthService,
WxMpFacadeService {
    private static final Logger log = LoggerFactory.getLogger(WxMpAuthServiceImpl.class);
    private UserAuthIntegrationService userAuthIntegrationService;
    private UserIntegrationService userIntegrationService;
    private WxMpService wxMpService;
    private WechatAccountConfig wechatAccountConfig;
    private WechatMPConfig wechatMPConfig;
    private UserVipIntegrationService userVipIntegrationService;
    private WxOfficialAccountService wxOfficialAccountService;

    @Override
    public Message getUserByCode(String code, String type) {
        this.swtichWechatMp(type);
        String appId = WxMpConfigStorageHolder.get();
        WxUserInfo wxUserInfo = this.getWxUserInfoByCode(code, type);
        if (Objects.nonNull(wxUserInfo) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)appId)) {
            this.wxOfficialAccountService.focusOnOfficialAccount(wxUserInfo.getOpenId(), wxUserInfo.getUnionId(), appId, Integer.valueOf(Objects.isNull(wxUserInfo.getUnionId()) ? 0 : 1));
        }
        if (null == wxUserInfo) {
            return Message.build((boolean)false);
        }
        Message wxUserInfoMessage = Message.build((boolean)true).addParam("wxUserInfo", (Object)wxUserInfo);
        if (wxUserInfoMessage.isSuccess()) {
            UserAuth userAuth = this.userAuthIntegrationService.selectUserAuthByUnionId(wxUserInfo.getUnionId());
            if (null != userAuth) {
                wxUserInfo.setUserId(userAuth.getUserId());
                wxUserInfo.setStatus(Integer.valueOf(2));
                UserInfoDTO userCache = this.userIntegrationService.getUserFromRedisDB(userAuth.getId());
                if (null != userCache && userCache.getState() != null && userCache.getState() == 1) {
                    wxUserInfo.setRegUser(Boolean.valueOf(true));
                }
                VipQueryParam vipQueryParam = new VipQueryParam();
                vipQueryParam.setUserId(userAuth.getUserId());
                VipInfoDetailDTO vipDetail = this.userVipIntegrationService.getVipDetail(vipQueryParam);
                if (vipDetail != null) {
                    wxUserInfo.setStatus(vipDetail.getStatus());
                }
            }
            if (log.isDebugEnabled()) {
                this.logger.debug("\u6839\u636ecode\u83b7\u53d6\u7528\u6237\u4fe1\u606f:[{}]", JSON.toJSON((Object)wxUserInfo));
            }
        }
        return wxUserInfoMessage;
    }

    @Override
    public WxMpUserList getUserList(String nextOpenId) {
        try {
            return this.wxMpService.getUserService().userList(nextOpenId);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public WxMpUser getUser(String openId) {
        try {
            return this.wxMpService.getUserService().userInfo(openId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public WxUserInfo getWxUserInfoByCode(String authCode, String type) {
        if (StringUtils.isBlank((CharSequence)authCode)) {
            return null;
        }
        WxUserInfo wxUserInfo = null;
        try {
            this.swtichWechatMp(type);
            WxMpOAuth2AccessToken wxMpOAuth2AccessToken = this.wxMpService.oauth2getAccessToken(authCode);
            WxMpUser wxMpUser = this.wxMpService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
            wxUserInfo = this.convertWxMpUser(wxMpUser);
        }
        catch (WxErrorException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return wxUserInfo;
    }

    private WxUserInfo convertWxMpUser(WxMpUser wxMpUser) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        wxUserInfo.setOpenId(wxMpUser.getOpenId());
        wxUserInfo.setUnionId(wxMpUser.getUnionId());
        wxUserInfo.setHeadImg(wxMpUser.getHeadImgUrl());
        if (com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)wxMpUser.getHeadImgUrl())) {
            wxUserInfo.setHeadImg(this.userIntegrationService.getDefaultHeadImgUrl());
        }
        wxUserInfo.setNickname(wxMpUser.getNickname());
        return wxUserInfo;
    }

    private void swtichWechatMp(String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            if (WechatMpTypeEnum.JS_API.name().equals(type)) {
                WxMpConfigStorageHolder.set((String)this.wechatAccountConfig.getJsapiAppId());
            } else {
                String appId = this.wechatMPConfig.getAppIdByType().get(type);
                if (StringUtils.isNotBlank((CharSequence)appId)) {
                    WxMpConfigStorageHolder.set((String)appId);
                } else {
                    WxMpConfigStorageHolder.set((String)this.wechatAccountConfig.getH5AppId());
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5207\u6362\u516c\u4f17\u53f7\uff0c\u6839\u636e\u7c7b\u578b: {}\u6700\u7ec8\u4f7f\u7528\u7684\u516c\u4f17\u53f7\u4fe1\u606f\u4e3a: {}", (Object)type, (Object)WxMpConfigStorageHolder.get());
        }
    }

    @Override
    public WxJsapiSignature getWxJsapiSignature(String url, String type) {
        try {
            this.swtichWechatMp(type);
            if (log.isDebugEnabled()) {
                log.debug("\u542f\u7528\u7684\u914d\u7f6e\u4fe1\u606f: {}", (Object)com.gexin.fastjson.JSON.toJSONString((Object)this.wxMpService.getWxMpConfigStorage()));
                this.swtichWechatMp(type);
            }
            return this.wxMpService.createJsapiSignature(url);
        }
        catch (WxErrorException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getWechatOnAuth2Url(String redirectURI, String scope, String state, String type) {
        this.swtichWechatMp(type);
        return String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&connect_redirect=1#wechat_redirect", this.wxMpService.getWxMpConfigStorage().getAppId(), redirectURI, scope, StringUtils.trimToEmpty((String)state));
    }

    public String getAccessToken() {
        String accessToken = null;
        try {
            WxMpConfigStorageHolder.set((String)this.wechatAccountConfig.getH5AppId());
            accessToken = this.wxMpService.getAccessToken();
        }
        catch (WxErrorException e) {
            this.logger.error("\u83b7\u53d6accessToken \u5931\u8d25:");
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return accessToken;
    }

    public Boolean subscribeWechat(String openId) {
        try {
            WxMpUser wxMpUser = this.wxMpService.getUserService().userInfo(openId);
            return wxMpUser.getSubscribe();
        }
        catch (WxErrorException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public WxMpAuthServiceImpl(UserAuthIntegrationService userAuthIntegrationService, UserIntegrationService userIntegrationService, WxMpService wxMpService, WechatAccountConfig wechatAccountConfig, WechatMPConfig wechatMPConfig, UserVipIntegrationService userVipIntegrationService, WxOfficialAccountService wxOfficialAccountService) {
        this.userAuthIntegrationService = userAuthIntegrationService;
        this.userIntegrationService = userIntegrationService;
        this.wxMpService = wxMpService;
        this.wechatAccountConfig = wechatAccountConfig;
        this.wechatMPConfig = wechatMPConfig;
        this.userVipIntegrationService = userVipIntegrationService;
        this.wxOfficialAccountService = wxOfficialAccountService;
    }
}

