/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.jump.impl;

import com.bxm.localnews.activity.common.config.ActivityProperties;
import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.impl.AbstractJumpInfoConvert;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import com.bxm.newidea.component.tools.MD5Util;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@Component
public class CouponJumpInfoConvert
extends AbstractJumpInfoConvert {
    private static final Logger log = LoggerFactory.getLogger(CouponJumpInfoConvert.class);
    private final ActivityProperties activityProperties;
    private static final String TQ_URL = "http://tq.jfshou.cn/seller/app/classify";

    @Override
    public Optional<JumpInfo> doConvert(JumpInfoConvertParam param) {
        if (Objects.isNull(param.getUserId())) {
            return Optional.empty();
        }
        JumpInfo jumpInfo = new JumpInfo();
        jumpInfo.setSourceJumpUrl(this.parseUrl(TQ_URL, param.getUserId()));
        jumpInfo.setProtocol(com.bxm.newidea.component.tools.StringUtils.join((Object[])new String[]{"wst://web/webDetail?url=", UriUtils.encode((String)jumpInfo.getSourceJumpUrl(), (Charset)Charset.defaultCharset())}));
        return Optional.of(jumpInfo);
    }

    private String parseUrl(String sourceUrl, Long userId) {
        if (StringUtils.isBlank((CharSequence)sourceUrl) || Objects.isNull(userId)) {
            return sourceUrl;
        }
        StringBuilder sb = new StringBuilder(sourceUrl);
        if (sourceUrl.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append("machineCode=").append(userId);
        sb.append("&agentId=").append(this.activityProperties.getTaoqi365AgentId());
        sb.append("&timestamp=").append(System.currentTimeMillis());
        String signStr = sb.toString();
        List paramList = URLEncodedUtils.parse((String)com.bxm.newidea.component.tools.StringUtils.substring((String)signStr, (int)(signStr.indexOf("?") + 1)), (Charset)StandardCharsets.UTF_8);
        paramList = paramList.stream().sorted(Comparator.comparing(NameValuePair::getName)).collect(Collectors.toList());
        StringBuilder signSource = new StringBuilder();
        for (NameValuePair nameValuePair : paramList) {
            if (com.bxm.newidea.component.tools.StringUtils.equalsAny((CharSequence)nameValuePair.getName(), (CharSequence[])this.activityProperties.getExcludeParam())) continue;
            signSource.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue());
            signSource.append("&");
        }
        signSource.append("secretKey").append("=").append(this.activityProperties.getTaoqi365SecertKey());
        sb.append("&sign=").append(MD5Util.hgmd5((String)signSource.toString()).toUpperCase());
        return sb.toString();
    }

    @Override
    public OrderJumpType support() {
        return OrderJumpType.COUPON_ORDER;
    }

    public CouponJumpInfoConvert(ActivityProperties activityProperties) {
        this.activityProperties = activityProperties;
    }
}

