/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.jump.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.ThirdpartyJumpInfoProperties;
import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.impl.AbstractJumpInfoConvert;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@Component
public class OilJumpInfoConvert
extends AbstractJumpInfoConvert {
    private static final Logger log = LoggerFactory.getLogger(OilJumpInfoConvert.class);
    @Autowired
    private ThirdpartyJumpInfoProperties thirdpartyJumpInfoProperties;
    @Autowired
    private UserIntegrationService userIntegrationService;

    @Override
    public Optional<JumpInfo> doConvert(JumpInfoConvertParam param) {
        UserInfoDTO userFromRedisDB = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userFromRedisDB)) {
            return Optional.empty();
        }
        JumpInfo jumpInfo = new JumpInfo();
        String uri = String.format(this.thirdpartyJumpInfoProperties.getOilUrl(), userFromRedisDB.getPhone());
        jumpInfo.setSourceJumpUrl(uri);
        jumpInfo.setProtocol(StringUtils.join((Object[])new String[]{"wst://web/webDetail?url=", UriUtils.encode((String)uri, (Charset)Charset.defaultCharset())}));
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u56e2\u6cb9\u7684\u8df3\u8f6c\u4fe1\u606f\u4e3a: {}", (Object)JSON.toJSONString((Object)jumpInfo));
        }
        return Optional.of(jumpInfo);
    }

    @Override
    public OrderJumpType support() {
        return OrderJumpType.OIL_ORDER;
    }
}

