/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.jump.impl;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.KfcProperty;
import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.impl.AbstractJumpInfoConvert;
import com.bxm.localnews.thirdparty.util.SignUtils;
import com.bxm.localnews.thirdparty.util.UrlParamsUtils;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;
import org.yaml.snakeyaml.util.UriEncoder;

@Component
public class QianNiuKfcHomePageJumpInfoConvert
extends AbstractJumpInfoConvert {
    private static final Logger log = LoggerFactory.getLogger(QianNiuKfcHomePageJumpInfoConvert.class);
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private KfcProperty kfcProperty;

    @Override
    public Optional<JumpInfo> doConvert(JumpInfoConvertParam param) {
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userInfoDTO)) {
            return Optional.empty();
        }
        try {
            HashMap signMap = Maps.newHashMap();
            signMap.put("platformUniqueId", param.getUserId());
            signMap.put("nickname", userInfoDTO.getNickname());
            signMap.put("platformId", this.kfcProperty.getPlatformId());
            signMap.put("timestamp", System.currentTimeMillis());
            signMap.put("redirectUrl", "/order/list");
            String sign = SignUtils.generateSign(signMap, this.kfcProperty.getSecret());
            signMap.put("sign", sign);
            signMap.put("nickname", UriEncoder.encode((String)userInfoDTO.getNickname()));
            String paramStr = UrlParamsUtils.toParams(signMap);
            JumpInfo jumpInfo = new JumpInfo();
            jumpInfo.setSourceJumpUrl(this.kfcProperty.getServerUrl() + "/api/v2/platform/login?" + paramStr);
            jumpInfo.setProtocol(StringUtils.join((Object[])new String[]{"wst://web/webDetail?url=", UriUtils.encode((String)jumpInfo.getSourceJumpUrl(), (Charset)Charset.defaultCharset())}));
            return Optional.of(jumpInfo);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5343\u732a\u80af\u5fb7\u57fa\u70b9\u9910\u9996\u9875\u5730\u5740\u5931\u8d25", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public OrderJumpType support() {
        return OrderJumpType.QIANZHU_KFC_HOMEPAGE;
    }
}

