/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.jump.impl;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.KfcProperty;
import com.bxm.localnews.thirdparty.constant.OrderJumpType;
import com.bxm.localnews.thirdparty.param.JumpInfoConvertParam;
import com.bxm.localnews.thirdparty.service.jump.impl.AbstractJumpInfoConvert;
import com.bxm.localnews.thirdparty.util.SignUtils;
import com.bxm.localnews.thirdparty.util.UrlParamsUtils;
import com.bxm.localnews.thirdparty.vo.JumpInfo;
import com.gexin.fastjson.JSON;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;
import org.yaml.snakeyaml.util.UriEncoder;

@Component
public class QianNiuKfcOrderPageJumpInfoConvert
extends AbstractJumpInfoConvert {
    private static final Logger log = LoggerFactory.getLogger(QianNiuKfcOrderPageJumpInfoConvert.class);
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private KfcProperty kfcProperty;

    @Override
    public Optional<JumpInfo> doConvert(JumpInfoConvertParam param) {
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userInfoDTO)) {
            return Optional.empty();
        }
        try {
            QianZhuUser user;
            QianZhuRes qianZhuRes;
            HashMap signMap = Maps.newHashMap();
            signMap.put("platformUniqueId", param.getUserId());
            signMap.put("nickname", userInfoDTO.getNickname());
            signMap.put("platformId", this.kfcProperty.getPlatformId());
            signMap.put("timestamp", System.currentTimeMillis());
            String sign = SignUtils.generateSign(signMap, this.kfcProperty.getSecret());
            signMap.put("sign", sign);
            signMap.put("nickname", UriEncoder.encode((String)userInfoDTO.getNickname()));
            String url = this.kfcProperty.getServerUrl() + "/api/v1/platform/getToken?" + UrlParamsUtils.toParams(signMap);
            if (log.isDebugEnabled()) {
                log.debug("\u83b7\u53d6\u5343\u732atoken\u4fe1\u606furl: {}", (Object)url);
            }
            String res = OkHttpUtils.getWithDefaultHeader((String)url, (Map)Maps.newHashMap());
            if (log.isDebugEnabled()) {
                log.debug("\u83b7\u53d6\u5343\u732atoken\u4fe1\u606fres: {}", (Object)res);
            }
            if (Objects.isNull(qianZhuRes = (QianZhuRes)JSON.parseObject((String)res, QianZhuRes.class)) || StringUtils.isBlank((CharSequence)qianZhuRes.getData()) || Objects.isNull(user = (QianZhuUser)JSON.parseObject((String)qianZhuRes.getData(), QianZhuUser.class))) {
                log.warn("\u8bf7\u6c42\u5343\u732a\u83b7\u53d6token\u5931\u8d25res: {}", (Object)res);
                return Optional.empty();
            }
            HashMap jumpMap = Maps.newHashMap();
            jumpMap.put("token", user.getAccessToken());
            jumpMap.put("platformId", this.kfcProperty.getPlatformId());
            String jumpStr = UrlParamsUtils.toParams(jumpMap);
            JumpInfo jumpInfo = new JumpInfo();
            jumpInfo.setSourceJumpUrl(this.kfcProperty.getPageUrl() + "/order/list?" + jumpStr);
            jumpInfo.setProtocol(com.bxm.newidea.component.tools.StringUtils.join((Object[])new String[]{"wst://web/webDetail?url=", UriUtils.encode((String)jumpInfo.getSourceJumpUrl(), (Charset)Charset.defaultCharset())}));
            return Optional.of(jumpInfo);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5343\u732a\u80af\u5fb7\u57fa\u70b9\u9910\u8ba2\u5355\u5730\u5740\u5931\u8d25", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public OrderJumpType support() {
        return OrderJumpType.QIANZHU_KFC_ORDER;
    }

    public static class QianZhuUser {
        private String accessToken;
        private Integer userId;

        public String getAccessToken() {
            return this.accessToken;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QianZhuUser)) {
                return false;
            }
            QianZhuUser other = (QianZhuUser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            Integer this$userId = this.getUserId();
            Integer other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QianZhuUser;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            Integer $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
            return result;
        }

        public String toString() {
            return "QianNiuKfcOrderPageJumpInfoConvert.QianZhuUser(accessToken=" + this.getAccessToken() + ", userId=" + this.getUserId() + ")";
        }
    }

    public static class QianZhuRes {
        private boolean success;
        private int code;
        private String message;
        private String data;

        public boolean isSuccess() {
            return this.success;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String getData() {
            return this.data;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setData(String data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QianZhuRes)) {
                return false;
            }
            QianZhuRes other = (QianZhuRes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof QianZhuRes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            result = result * 59 + this.getCode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "QianNiuKfcOrderPageJumpInfoConvert.QianZhuRes(success=" + this.isSuccess() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
        }
    }
}

