/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.pop;

import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopConfig;
import com.bxm.localnews.thirdparty.service.pop.popinstance.Pop;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopCache;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.PopStrategy;
import com.bxm.localnews.thirdparty.service.pop.popstrategy.impl.AbstractPopStrategy;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class PopFactory
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(PopFactory.class);
    private ApplicationContext applicationContext;
    private Pop firstPop;
    private static final Map<Class<? extends PopStrategy>, PopStrategy> POP_STRATEGY_MAP = new HashMap<Class<? extends PopStrategy>, PopStrategy>();
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    public HomeWindowDTO process(HomeWindowParam homeWindowParam) {
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u59cb\u5904\u7406\u5f39\u7a97\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        }
        Map cacheMap = this.redisHashMapAdapter.entries(AbstractPopStrategy.getRedisKey(homeWindowParam.getUserId()), PopCache.class);
        PopContext popContext = new PopContext();
        popContext.setHomeWindowParam(homeWindowParam);
        popContext.setCacheMap(cacheMap);
        this.firstPop.process(popContext);
        if (log.isDebugEnabled()) {
            log.debug("\u7ed3\u675f\u5904\u7406\u5f39\u7a97\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        }
        return popContext.getHomeWindowDTO();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void onApplicationEvent(ApplicationReadyEvent event) {
        Collection popStrategyList = this.applicationContext.getBeansOfType(PopStrategy.class).values();
        popStrategyList.forEach(popStrategy -> POP_STRATEGY_MAP.put((Class<? extends PopStrategy>)popStrategy.getClass(), (PopStrategy)popStrategy));
        Collection popList = this.applicationContext.getBeansOfType(Pop.class).values();
        popList.forEach(pop -> {
            Class<? extends PopStrategy> popStrategy = PopConfig.getStrategy(pop.getClass());
            if (null != popStrategy) {
                pop.setPopStrategy(POP_STRATEGY_MAP.get(popStrategy));
            }
            pop.setParam(PopConfig.getParam(pop.getClass()));
        });
        List result = popList.stream().sorted(Comparator.comparingInt(PopConfig::getOrder)).collect(Collectors.toList());
        for (int i = 0; i < result.size() - 1; ++i) {
            ((Pop)result.get(i)).setNext((Pop)result.get(i + 1));
        }
        this.firstPop = (Pop)result.get(0);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

