/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popinstance.impl.AbstractPop;
import com.google.common.base.Charsets;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HomePagePop
extends AbstractPop {
    private static final Logger log = LoggerFactory.getLogger(HomePagePop.class);
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private BizConfigProperties bizConfigProperties;
    @Autowired
    private BaseUrlFacadeService baseUrlFacadeService;

    @Override
    public boolean filter(PopContext context) {
        log.debug("\u5f00\u59cb\u5904\u7406\u4e2a\u4eba\u4e3b\u9875\u5f39\u7a97\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        boolean result = false;
        HomeWindowParam homeWindowParam = context.getHomeWindowParam();
        String homePageUrl = this.getHomePage(homeWindowParam.getUserId());
        if (StringUtils.isNotBlank((CharSequence)homePageUrl)) {
            context.setHomeWindowDTO(new HomeWindowDTO(Integer.valueOf(PopTypeEnum.HOME_PAGE_POP.getType()), homePageUrl));
            result = true;
        }
        log.debug("\u7ed3\u675f\u5904\u7406\u4e2a\u4eba\u4e3b\u9875\u5f39\u7a97\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        return result;
    }

    private String getHomePage(Long userId) {
        UserInfoDTO userInfo = this.userIntegrationService.getUserFromRedisDB(userId);
        if (null != userInfo && InviteTypeEnum.PERSONAL_HOMEPAGE.getName().equalsIgnoreCase(userInfo.getRegisterChannel()) && null != userInfo.getInviteUserId() && null != userInfo.getRelationId()) {
            UserInfoDTO inviteUserInfo = this.userIntegrationService.getUserFromRedisDB(userInfo.getRelationId());
            String nickname = null == inviteUserInfo.getNickname() ? "\u533f\u540d" : inviteUserInfo.getNickname();
            String headImg = null == inviteUserInfo.getHeadImg() ? this.userIntegrationService.getDefaultHeadImgUrl() : inviteUserInfo.getHeadImg();
            try {
                StringBuilder sb = new StringBuilder(this.baseUrlFacadeService.getInnerH5BaseUrl());
                sb.append("/index.html#/guideFollow?userId=");
                sb.append(userId);
                sb.append("&userName=");
                sb.append(URLEncoder.encode(nickname, Charsets.UTF_8.name()));
                sb.append("&userUrl=");
                sb.append(URLEncoder.encode(headImg, Charsets.UTF_8.name()));
                sb.append("&followUserId=");
                sb.append(inviteUserInfo.getId());
                return sb.toString();
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u6536\u4e2a\u4eba\u6ce8\u518c\u5f39\u7a97\u5730\u5740\u5931\u8d25", (Throwable)e);
            }
        }
        return null;
    }
}

