/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.ForumPostIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popinstance.impl.AbstractPop;
import com.bxm.localnews.vo.TopicFacadeVO;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopicPop
extends AbstractPop {
    private static final Logger log = LoggerFactory.getLogger(TopicPop.class);
    @Autowired
    private ForumPostIntegrationService forumPostIntegrationService;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    protected boolean filter(PopContext context) {
        TopicFacadeVO topicFacadeVO;
        UserInfoDTO userInfoDTO;
        Long userId = context.getHomeWindowParam().getUserId();
        if (Objects.nonNull(userId) && !this.redisSetAdapter.exists(RedisConfig.CONTENT_GUIDE_KEY, (Object)userId).booleanValue() && Objects.nonNull(userInfoDTO = this.userIntegrationService.getUserFromRedisDB(userId)) && Objects.nonNull(userInfoDTO.getId()) && Objects.equals(InviteTypeEnum.TOPIC.getName(), userInfoDTO.getRegisterChannel()) && Objects.nonNull(topicFacadeVO = this.forumPostIntegrationService.getTopicById(userInfoDTO.getRelationId()))) {
            HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
            homeWindowDTO.setTopicFacadeVO(topicFacadeVO);
            homeWindowDTO.setType(Integer.valueOf(PopTypeEnum.HOME_TOPIC_POP.getType()));
            context.setHomeWindowDTO(homeWindowDTO);
            return true;
        }
        return false;
    }
}

