/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popinstance.impl.AbstractPop;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VipPageTabPop
extends AbstractPop {
    private static final Logger log = LoggerFactory.getLogger(VipPageTabPop.class);
    private final UserIntegrationService userIntegrationService;

    @Override
    boolean filter(PopContext context) {
        HomeWindowParam param = context.getHomeWindowParam();
        if (Objects.isNull(param.getCurVer())) {
            return false;
        }
        if (Boolean.FALSE.equals(StringUtils.isGrateOrEqualThan((String)param.getCurVer(), (String)"3.11.0"))) {
            return false;
        }
        UserInfoDTO userInfo = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userInfo)) {
            log.warn("\u7528\u6237: {}\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc73.11.0\u7248\u672cVIP Tab\u5f39\u7a97", (Object)param.getUserId());
            return false;
        }
        if (this.check3110JudgeMarker(userInfo.getJudgeMarker())) {
            log.info("\u7528\u6237: {} \u662f\u65b0\u7248\u672c3.11.0\u7528\u6237\uff0c\u4e0d\u5f39\u51favip tab", (Object)param.getUserId());
            return false;
        }
        HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
        homeWindowDTO.setType(Integer.valueOf(PopTypeEnum.VIP_PAGE_TAB_POP.getType()));
        context.setHomeWindowDTO(homeWindowDTO);
        return true;
    }

    protected boolean check3110JudgeMarker(Long judgeMarket) {
        return BitOperatorUtil.getBitAsBoolean((Long)judgeMarket, (int)LocalNewsUserJudgeMarkerEnum.VER_3_11_0.getIndex());
    }

    public VipPageTabPop(UserIntegrationService userIntegrationService) {
        this.userIntegrationService = userIntegrationService;
    }
}

