/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.pop.popinstance.impl;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.dto.VoteHomeDTO;
import com.bxm.localnews.integration.ForumPostIntegrationService;
import com.bxm.localnews.integration.NewsIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.dto.HomeWindowDTO;
import com.bxm.localnews.thirdparty.param.HomeWindowParam;
import com.bxm.localnews.thirdparty.service.pop.PopTypeEnum;
import com.bxm.localnews.thirdparty.service.pop.popinstance.PopContext;
import com.bxm.localnews.thirdparty.service.pop.popinstance.impl.AbstractPop;
import com.bxm.localnews.vo.ForumPostBriefInfoDto;
import com.bxm.localnews.vo.NewsBriefInfoDto;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VotePop
extends AbstractPop {
    private static final Logger log = LoggerFactory.getLogger(VotePop.class);
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private ForumPostIntegrationService forumPostIntegrationService;
    @Autowired
    private NewsIntegrationService newsIntegrationService;

    @Override
    public boolean filter(PopContext context) {
        log.debug("\u5f00\u59cb\u5904\u7406\u6295\u7968\u5f39\u7a97\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        boolean result = false;
        HomeWindowParam homeWindowParam = context.getHomeWindowParam();
        VoteHomeDTO voteHome = this.getVotePost(homeWindowParam.getUserId(), homeWindowParam.getAreaCode(), homeWindowParam.getAreaName());
        if (null != voteHome) {
            HomeWindowDTO homeWindowDTO = new HomeWindowDTO();
            homeWindowDTO.setVoteHomeDTO(voteHome);
            homeWindowDTO.setType(Integer.valueOf(PopTypeEnum.VOTE_POP.getType()));
            context.setHomeWindowDTO(homeWindowDTO);
            result = true;
        }
        log.debug("\u7ed3\u675f\u5904\u7406\u6295\u7968\u5f39\u7a97\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        return result;
    }

    private VoteHomeDTO getVotePost(Long userId, String areaCode, String areaName) {
        UserInfoDTO userInfo;
        if (!this.redisSetAdapter.exists(RedisConfig.CONTENT_GUIDE_KEY, (Object)userId).booleanValue() && Objects.nonNull(userInfo = this.userIntegrationService.getUserFromRedisDB(userId)) && null != userInfo.getInviteUserId()) {
            if (InviteTypeEnum.FORUM.getName().equalsIgnoreCase(userInfo.getRegisterChannel())) {
                ForumPostBriefInfoDto postInfo = this.forumPostIntegrationService.getPostBriefInfo(userInfo.getRelationId(), userId, areaCode, areaName);
                if (postInfo.getId() == null) {
                    return null;
                }
                return VoteHomeDTO.builder().coverImg(postInfo.getConvertImgUrl()).title(postInfo.getTitle()).id(postInfo.getId()).hasVote(postInfo.getHasVote()).type("FORUM").build();
            }
            if (InviteTypeEnum.NEWS.getName().equalsIgnoreCase(userInfo.getRegisterChannel())) {
                NewsBriefInfoDto newsInfo = this.newsIntegrationService.getPostBriefInfo(userInfo.getRelationId(), userId, areaCode);
                if (newsInfo == null || newsInfo.getId() == null) {
                    return null;
                }
                return VoteHomeDTO.builder().coverImg(newsInfo.getConvertImgUrl()).title(newsInfo.getTitle()).id(newsInfo.getId()).hasVote(newsInfo.getHasVote()).type("NEWS").build();
            }
        }
        return null;
    }
}

