/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.wx.push.impl;

import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.localnews.thirdparty.config.WechatMPConfig;
import com.bxm.localnews.thirdparty.constant.WechatMpTypeEnum;
import com.bxm.localnews.thirdparty.service.wx.push.WxMpMessageService;
import com.bxm.localnews.thirdparty.service.wx.push.templateStrategy.WxTemplateContextProcess;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpTemplateMsgService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import me.chanjar.weixin.mp.util.WxMpConfigStorageHolder;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMpMessageServiceImpl
implements WxMpMessageService {
    private static final Logger log = LoggerFactory.getLogger(WxMpMessageServiceImpl.class);
    private final WxMpService wxMpService;
    private final WechatMPConfig wechatMpConfig;
    private final WxTemplateContextProcess wxTemplateContextProcess;

    @Override
    public Message singlePush(WechatMpPushMessage message) {
        if (null == message || StringUtils.isBlank((String)message.getOid()) || MapUtils.isEmpty((Map)message.getValueMap())) {
            log.warn("\u4f7f\u7528\u516c\u4f17\u53f7\u63a8\u9001\uff0c\u53c2\u6570\u4e0d\u5b8c\u6574:{}", (Object)message);
            return Message.build((boolean)false, (String)"\u672a\u5f00\u542f\u516c\u4f17\u53f7\u63a8\u9001\u529f\u80fd");
        }
        String templateId = this.wxTemplateContextProcess.getTemplateId(message.getWxMpTemplate());
        if (null == templateId) {
            log.warn("\u4f7f\u7528\u516c\u4f17\u53f7\u63a8\u9001\uff0c\u6a21\u677f\u4e0d\u5b58\u5728\uff1a{}", (Object)message);
            return Message.build((boolean)false, (String)"\u4f7f\u7528\u516c\u4f17\u53f7\u63a8\u9001\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        message.setTemplateId(templateId);
        List<WxMpTemplateData> wxMaTemplateDataList = this.generateTemplate(message);
        return this.sendTemplate(message, wxMaTemplateDataList, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message sendTemplate(WechatMpPushMessage message, List<WxMpTemplateData> list, int retryTimes) {
        if (retryTimes == 0) {
            log.error("\u91cd\u8bd5\u540e\u53d1\u9001\u6a21\u677f\u6d88\u606f\u4ecd\u7136\u5931\u8d25");
            return Message.build((boolean)false);
        }
        try {
            String templateId = message.getTemplateId();
            Map<String, String> appIdByType = this.wechatMpConfig.getAppIdByType();
            log.debug("\u7ed9\u7528\u6237[{}]\u53d1\u9001[{}]\u6a21\u677f\u6d88\u606f", (Object)message.getUserId(), (Object)templateId);
            WxMpTemplateMsgService service = this.wxMpService.getTemplateMsgService();
            WxMpConfigStorageHolder.set((String)appIdByType.get(WechatMpTypeEnum.PUSHMSG.name()));
            String msgId = service.sendTemplateMsg(WxMpTemplateMessage.builder().templateId(templateId).data(list).url(message.getUrl()).toUser(message.getOid()).build());
            log.info("\u7d66\u7528\u6236[{}]\u53d1\u9001\u516c\u4f17\u53f7\u6d88\u606f\u6210\u529f\uff0c\u6d88\u606fID[{}]", (Object)message.getUserId(), (Object)msgId);
            Message message2 = Message.build((boolean)true);
            return message2;
        }
        catch (WxErrorException e) {
            log.warn("\u7ed9\u7528\u6237\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5931\u8d25", (Throwable)e);
            Message message3 = this.sendTemplate(message, list, --retryTimes);
            return message3;
        }
        finally {
            WxMpConfigStorageHolder.set((String)"default");
        }
    }

    private List<WxMpTemplateData> generateTemplate(WechatMpPushMessage message) {
        ArrayList templateDataList = Lists.newArrayList();
        message.getValueMap().forEach((postion, content) -> templateDataList.add(new WxMpTemplateData(postion, content)));
        return templateDataList;
    }

    @Autowired
    public WxMpMessageServiceImpl(WxMpService wxMpService, WechatMPConfig wechatMpConfig, WxTemplateContextProcess wxTemplateContextProcess) {
        this.wxMpService = wxMpService;
        this.wechatMpConfig = wechatMpConfig;
        this.wxTemplateContextProcess = wxTemplateContextProcess;
    }
}

