/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class SignUtil {
    private static final String SIGN_SEPARATOR = "\n";

    public static void main(String[] args) throws Exception {
        URI uri = new URIBuilder().setScheme("https").setHost("open-am.xiaojukeji.com/am/open/api").setPath("/user/auth").build();
        HttpPost request = new HttpPost(uri);
        String body = "{\"encryptPhone\":\"BSneGm9NR+3KZSnaE3AKSA==\",\"deliveryMethod\":\"LINK\",\"openChannel\":1,\"bizLine\":\"ENERGY\"}";
        ContentType contentType = ContentType.APPLICATION_JSON;
        StringEntity se = new StringEntity(body, contentType);
        se.setContentEncoding("UTF-8");
        request.setEntity((HttpEntity)se);
        String appKey = "jxMvk6bmCziMB3qasTRk+3kwj1nAcJWUezZeJ45ukak=";
        request.setHeader("x-cas-key", appKey);
        String date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date());
        request.setHeader("x-date", date);
        request.setHeader("content-type", contentType.getMimeType());
        request.setHeader("content-md5", SignUtil.md5Encrypt(body));
        String appSecret = "EmVwHrP7Gtz796LW7hwBSJ7fSSHJMjXpY0yxlxrHNl4=";
        String signSource = SignUtil.buildSignSource(request.getMethod(), body, contentType.getMimeType(), date, appKey, uri.getPath(), uri.getQuery());
        String sign = SignUtil.calculateSign(signSource, appSecret);
        request.setHeader("sign", sign);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);
        System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    public static String md5Encrypt(String text) throws Exception {
        return DigestUtils.md5Hex((String)text);
    }

    public static String buildSignSource(String method, String body, String contentType, String date, String xCasKey, String path, String query) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(method.toUpperCase()).append(SIGN_SEPARATOR);
        if (Objects.nonNull(body)) {
            sb.append(SignUtil.md5Encrypt(body)).append(SIGN_SEPARATOR);
        }
        sb.append(contentType).append(SIGN_SEPARATOR);
        sb.append(date).append(SIGN_SEPARATOR);
        sb.append("x-cas-key:").append(xCasKey).append(SIGN_SEPARATOR);
        sb.append(path);
        if (Objects.nonNull(query)) {
            sb.append("?");
            sb.append(SignUtil.buildQueries(query));
        }
        return sb.toString();
    }

    private static String buildQueries(String query) {
        String[] queries = query.split("&");
        TreeMap<String, String> queryMap = new TreeMap<String, String>();
        Arrays.stream(queries).forEach(queryItem -> {
            String[] keyValue = queryItem.split("=");
            queryMap.put(keyValue[0], keyValue[1]);
        });
        StringBuilder sb = new StringBuilder();
        queryMap.forEach((key, value) -> sb.append((String)key).append("=").append((String)value).append("&"));
        String result = sb.toString();
        if (result.endsWith("")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String calculateSign(String source, String accessSecret) throws InvalidKeyException {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(accessSecret.getBytes("UTF-8"), "HmacSHA256"));
            byte[] signData = mac.doFinal(source.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(signData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("HMAC-SHA1 not supported.");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported.");
        }
    }
}

