package com.bxm.localnews.user.controller;

import java.util.List;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.CashFlowDTO;
import com.bxm.localnews.user.param.CashFlowParam;
import com.bxm.localnews.user.service.CashFlowService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author zhaoyadong 2019/3/4 14:34
 * @desc
 */
@Api(tags = "9-07 用户现金流水相关API", description = "用户流水相关信息")
@RestController
@RequestMapping("api/user/cash/flow")
public class CashFlowController {

    @Resource
    private CashFlowService cashFlowService;

    @ApiOperation(value = "9-07-1 获取用户流水信息", notes = "用户的流水列表")
    @GetMapping()
    public Json<List<CashFlowDTO>> getUserCashFlow(CashFlowParam cashFlowParam) {
        return ResultUtil.genSuccessResult(this.cashFlowService.getUserAllCashFlow(cashFlowParam));
    }
}
